/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class TemporarySpace {
    private static final String FRAG = "protobuf-maven-plugin";
    private static final Logger log = LoggerFactory.getLogger(TemporarySpace.class);
    private final MavenProject mavenProject;

    @Inject
    public TemporarySpace(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public Path createTemporarySpace(String ... bits) {
        Path dir = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]).resolve(FRAG);
        for (String bit : bits) {
            dir = dir.resolve(bit);
        }
        log.debug("Creating temporary directory at '{}' if it does not already exist...", (Object)dir);
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to create temporary directory!", ex);
        }
    }
}

