/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ArgLineBuilder {
    private final Path protocPath;
    private boolean fatalWarnings;
    private final List<Target> targets;
    private final List<Path> importPaths;

    public ArgLineBuilder(Path protocPath) {
        this.protocPath = protocPath;
        this.fatalWarnings = false;
        this.targets = new ArrayList<Target>();
        this.importPaths = new ArrayList<Path>();
    }

    public List<String> compile(Collection<Path> sourcesToCompile) {
        if (this.targets.isEmpty()) {
            throw new IllegalStateException("No output target operations were provided");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.protocPath.toString());
        if (this.fatalWarnings) {
            args.add("--fatal_warnings");
        }
        for (Target target : this.targets) {
            target.addArgsTo(args);
        }
        for (Path sourceToCompile : sourcesToCompile) {
            args.add(sourceToCompile.toString());
        }
        for (Path importPath : this.importPaths) {
            args.add("--proto_path=" + importPath.toString());
        }
        return Collections.unmodifiableList(args);
    }

    public ArgLineBuilder fatalWarnings(boolean fatalWarnings) {
        this.fatalWarnings = fatalWarnings;
        return this;
    }

    public ArgLineBuilder generateCodeFor(Language language, Path outputPath, boolean lite) {
        this.targets.add(new LanguageTarget(language, outputPath, lite));
        return this;
    }

    public ArgLineBuilder importPaths(Collection<Path> importPaths) {
        this.importPaths.addAll(importPaths);
        return this;
    }

    public ArgLineBuilder plugins(Collection<ResolvedProtocPlugin> plugins, Path outputPath) {
        for (ResolvedProtocPlugin plugin : plugins) {
            this.targets.add(new PluginTarget(plugin, outputPath));
        }
        return this;
    }

    private static interface Target {
        public void addArgsTo(List<String> var1);
    }

    private static final class LanguageTarget
    implements Target {
        private final Language language;
        private final Path outputPath;
        private final boolean lite;

        private LanguageTarget(Language language, Path outputPath, boolean lite) {
            this.language = language;
            this.outputPath = outputPath;
            this.lite = lite;
        }

        @Override
        public void addArgsTo(List<String> list) {
            String flag = "--" + this.language.getFlagName() + "_out=" + (this.lite ? "lite:" : "") + String.valueOf(this.outputPath);
            list.add(flag);
        }
    }

    private static final class PluginTarget
    implements Target {
        private final ResolvedProtocPlugin plugin;
        private final Path outputPath;

        private PluginTarget(ResolvedProtocPlugin plugin, Path outputPath) {
            this.plugin = plugin;
            this.outputPath = outputPath;
        }

        @Override
        public void addArgsTo(List<String> list) {
            list.add("--plugin=protoc-gen-" + this.plugin.getId() + "=" + String.valueOf(this.plugin.getPath()));
            list.add("--" + this.plugin.getId() + "_out=" + String.valueOf(this.outputPath));
            this.plugin.getOptions().map(options -> "--" + this.plugin.getId() + "_opt=" + options).ifPresent(list::add);
        }
    }
}

