/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.sources.ImmutableProtoFileListing;
import io.github.ascopes.protobufmavenplugin.sources.ProtoArchiveExtractor;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileFilter;
import io.github.ascopes.protobufmavenplugin.sources.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.utils.ConcurrentExecutor;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtoSourceResolver {
    private static final Set<String> POM_FILE_EXTENSIONS = Set.of(".pom", ".xml");
    private static final Set<String> ZIP_FILE_EXTENSIONS = Set.of(".jar", ".zip");
    private static final Logger log = LoggerFactory.getLogger(ProtoArchiveExtractor.class);
    private final ConcurrentExecutor concurrentExecutor;
    private final ProtoArchiveExtractor protoArchiveExtractor;

    @Inject
    public ProtoSourceResolver(ConcurrentExecutor concurrentExecutor, ProtoArchiveExtractor protoArchiveExtractor) {
        this.concurrentExecutor = concurrentExecutor;
        this.protoArchiveExtractor = protoArchiveExtractor;
    }

    public Collection<ProtoFileListing> createProtoFileListings(Collection<Path> rootPaths, ProtoFileFilter filter) {
        return rootPaths.stream().map(FileUtils::normalize).distinct().map(path -> this.concurrentExecutor.submit(() -> this.createProtoFileListing((Path)path, filter))).collect(this.concurrentExecutor.awaiting()).stream().flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<ProtoFileListing> createProtoFileListing(Path rootPath, ProtoFileFilter filter) throws IOException {
        if (!Files.exists(rootPath, new LinkOption[0])) {
            log.debug("Skipping lookup in path {} as it does not exist", (Object)rootPath);
            return Optional.empty();
        }
        if (Files.isRegularFile(rootPath, new LinkOption[0])) {
            return this.createProtoFileListingForArchive(rootPath, filter);
        }
        try (Stream<Path> stream = Files.walk(rootPath, new FileVisitOption[0]);){
            Optional<ProtoFileListing> optional = stream.filter(filePath -> filter.matches(rootPath, (Path)filePath)).peek(protoFile -> log.debug("Found proto file in root {}: {}", (Object)rootPath, protoFile)).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Optional::of)).filter(Predicate.not(Collection::isEmpty)).map(protoFiles -> ImmutableProtoFileListing.builder().addAllProtoFiles((Iterable<? extends Path>)protoFiles).protoFilesRoot(rootPath).build());
            return optional;
        }
    }

    private Optional<ProtoFileListing> createProtoFileListingForArchive(Path rootPath, ProtoFileFilter filter) throws IOException {
        Optional<String> fileExtension = FileUtils.getFileExtension(rootPath);
        if (fileExtension.filter(ZIP_FILE_EXTENSIONS::contains).isPresent()) {
            return this.protoArchiveExtractor.extractProtoFiles(rootPath, filter);
        }
        if (fileExtension.filter(POM_FILE_EXTENSIONS::contains).isPresent()) {
            log.debug("Ignoring invalid dependency on potential POM at {}", (Object)rootPath);
            return Optional.empty();
        }
        log.warn("Ignoring unknown archive type at {}", (Object)rootPath);
        return Optional.empty();
    }
}

