/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.sources.DescriptorListing;
import io.github.ascopes.protobufmavenplugin.sources.ImmutableProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.ProjectInputListing;
import io.github.ascopes.protobufmavenplugin.sources.ProtoSourceResolver;
import io.github.ascopes.protobufmavenplugin.sources.SourceListing;
import io.github.ascopes.protobufmavenplugin.sources.filter.FileFilter;
import io.github.ascopes.protobufmavenplugin.sources.filter.IncludesExcludesGlobFilter;
import io.github.ascopes.protobufmavenplugin.sources.filter.ProtoFileFilter;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Resolves all protobuf sources to compile and/or make importable in the project")
@MojoExecutionScoped
@Named
public final class ProjectInputResolver {
    private static final Logger log = LoggerFactory.getLogger(ProjectInputResolver.class);
    private final MavenArtifactPathResolver artifactPathResolver;
    private final ProtoSourceResolver sourceResolver;

    @Inject
    ProjectInputResolver(MavenArtifactPathResolver artifactPathResolver, ProtoSourceResolver sourceResolver) {
        this.artifactPathResolver = artifactPathResolver;
        this.sourceResolver = sourceResolver;
    }

    public ProjectInputListing resolveProjectInputs(GenerationRequest request) throws ResolutionException {
        IncludesExcludesGlobFilter filter = new IncludesExcludesGlobFilter(request.getIncludes(), request.getExcludes());
        return ImmutableProjectInputListing.builder().compilableDescriptorFiles(this.resolveCompilableDescriptorSources(request, filter)).compilableProtoSources(this.resolveCompilableProtoSources(request, filter)).dependencyProtoSources(this.resolveDependencyProtoSources(request)).build();
    }

    private Collection<SourceListing> resolveCompilableProtoSources(GenerationRequest request, FileFilter filter) throws ResolutionException {
        log.debug("Discovering all compilable protobuf source files");
        filter = new ProtoFileFilter().and(filter);
        Collection<SourceListing> sourcePathsListings = this.sourceResolver.resolveSources(request.getSourceDirectories(), filter);
        List<Path> sourceDependencies = this.artifactPathResolver.resolveDependencies(request.getSourceDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), false, request.isFailOnInvalidDependencies());
        Collection<SourceListing> sourceDependencyListings = this.sourceResolver.resolveSources(sourceDependencies, filter);
        return Stream.concat(sourcePathsListings.stream(), sourceDependencyListings.stream()).distinct().collect(Collectors.toUnmodifiableList());
    }

    private Collection<SourceListing> resolveDependencyProtoSources(GenerationRequest request) throws ResolutionException {
        ProtoFileFilter filter = new ProtoFileFilter();
        List<Path> artifactPaths = this.artifactPathResolver.resolveDependencies(request.getImportDependencies(), request.getDependencyResolutionDepth(), request.getDependencyScopes(), !request.isIgnoreProjectDependencies(), request.isFailOnInvalidDependencies());
        List<Path> importPaths = Stream.concat(request.getImportPaths().stream(), artifactPaths.stream()).distinct().collect(Collectors.toUnmodifiableList());
        return this.sourceResolver.resolveSources(importPaths, (FileFilter)filter);
    }

    private Collection<DescriptorListing> resolveCompilableDescriptorSources(GenerationRequest request, FileFilter filter) throws ResolutionException {
        List<Path> artifactPaths = this.artifactPathResolver.resolveDependencies(request.getSourceDescriptorDependencies(), DependencyResolutionDepth.DIRECT, request.getDependencyScopes(), false, request.isFailOnInvalidDependencies());
        List<Path> descriptorFilePaths = Stream.concat(request.getSourceDescriptorPaths().stream(), artifactPaths.stream()).distinct().collect(Collectors.toUnmodifiableList());
        return this.sourceResolver.resolveDescriptors(descriptorFilePaths, filter);
    }
}

