/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

public final class Digests {
    private Digests() {
    }

    public static String sha1(String string) {
        MessageDigest messageDigest = Digests.createMessageDigest("SHA-1");
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return Digests.base64Encode(messageDigest.digest(bytes));
    }

    public static String sha512ForStream(InputStream inputStream) throws IOException {
        int offset;
        MessageDigest messageDigest = Digests.createMessageDigest("SHA-512");
        byte[] buff = new byte[4096];
        while ((offset = inputStream.read(buff)) != -1) {
            messageDigest.update(buff, 0, offset);
        }
        return Digests.base64Encode(messageDigest.digest());
    }

    private static String base64Encode(byte[] digest) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    private static MessageDigest createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

