/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc.targets;

import io.github.ascopes.protobufmavenplugin.fs.AbstractTemporaryLocationProvider;
import io.github.ascopes.protobufmavenplugin.plugins.ImmutableResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.protoc.ImmutableProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.ProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ImmutablePluginProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.PluginProtocTarget;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Moves executable targets to a user-specified location for corporate environments")
@MojoExecutionScoped
@Named
public final class SanctionedExecutableTransformer
extends AbstractTemporaryLocationProvider {
    private static final Logger log = LoggerFactory.getLogger(SanctionedExecutableTransformer.class);
    private final MavenProject mavenProject;

    @Inject
    public SanctionedExecutableTransformer(MavenProject mavenProject, MojoExecution mojoExecution) {
        super(mojoExecution);
        this.mavenProject = mavenProject;
    }

    public ProtocInvocation transform(ProtocInvocation protocInvocation) throws IOException {
        Path sanctionedPath = protocInvocation.getSanctionedExecutablePath();
        if (sanctionedPath == null) {
            log.debug("No sanctioned executable location specified; will not intercept the protoc invocation");
            return protocInvocation;
        }
        log.warn("A user-specified sanctioned execution location of \"{}\" was provided. All executables managed by this plugin invocation will be moved to that location. Your mileage may vary, and it will be up to you to manage cleaning up this path.", (Object)sanctionedPath);
        sanctionedPath = sanctionedPath.resolve(this.mavenProject.getGroupId()).resolve(this.mavenProject.getArtifactId());
        sanctionedPath = this.resolveAndCreateDirectory(sanctionedPath, new String[0]);
        Files.createDirectories(sanctionedPath, new FileAttribute[0]);
        return ImmutableProtocInvocation.builder().from(protocInvocation).protocPath(this.transfer(sanctionedPath, "protoc-", protocInvocation.getProtocPath())).targets(this.transformTargets(sanctionedPath, protocInvocation)).build();
    }

    private SortedSet<ProtocTarget> transformTargets(Path sanctionedPath, ProtocInvocation invocation) throws IOException {
        TreeSet<ProtocTarget> transformedTargets = new TreeSet<ProtocTarget>();
        for (ProtocTarget target : invocation.getTargets()) {
            if (target instanceof PluginProtocTarget) {
                PluginProtocTarget pluginTarget = (PluginProtocTarget)target;
                String prefix = "plugin-" + transformedTargets.size() + "-";
                target = ImmutablePluginProtocTarget.builder().from(pluginTarget).plugin(ImmutableResolvedProtocPlugin.builder().from(pluginTarget.getPlugin()).path(this.transfer(sanctionedPath, prefix, pluginTarget.getPlugin().getPath())).build()).build();
            }
            transformedTargets.add(target);
        }
        return Collections.unmodifiableSortedSet(transformedTargets);
    }

    private Path transfer(Path sanctionedPath, String prefix, Path existingFile) throws IOException {
        Path newFile = sanctionedPath.resolve(prefix + existingFile.getFileName().toString());
        log.debug("Copying \"{}\" to \"{}\"", (Object)existingFile, (Object)newFile);
        return Files.copy(existingFile, newFile, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }
}

