/*
 * Decompiled with CFR 0.152.
 */
package qrcode;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qrcode.QRCode;
import qrcode.QRCodeShapesEnum;
import qrcode.color.DefaultColorFunction;
import qrcode.color.LinearGradientColorFunction;
import qrcode.color.QRCodeColorFunction;
import qrcode.internals.QRCodeSquare;
import qrcode.internals.QRMath;
import qrcode.raw.ErrorCorrectionLevel;
import qrcode.raw.MaskPattern;
import qrcode.raw.QRCodeProcessor;
import qrcode.render.QRCodeGraphics;
import qrcode.render.QRCodeGraphicsFactory;
import qrcode.shape.CircleShapeFunction;
import qrcode.shape.DefaultShapeFunction;
import qrcode.shape.QRCodeShapeFunction;
import qrcode.shape.RoundSquaresShapeFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000bJ)\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u000bJ\u0019\u00103\u001a\u00020\u00002\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\u00105J,\u00106\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000b2\b\b\u0002\u0010;\u001a\u00020\u0010H\u0007J%\u0010<\u001a\u00020\u00002\u001d\u0010=\u001a\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180>\u00a2\u0006\u0002\b\u0019J%\u0010?\u001a\u00020\u00002\u001d\u0010=\u001a\u0019\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180>\u00a2\u0006\u0002\b\u0019J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u001eJ\u0010\u0010B\u001a\u00020\u00002\b\u0010C\u001a\u0004\u0018\u00010\tJ\u0010\u0010D\u001a\u00020\u00002\b\u0010E\u001a\u0004\u0018\u00010\u0005J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020 J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000bJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000bJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020XR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u0014\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001a\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001b\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001c\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R7\u0010N\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR7\u0010Q\u001a%\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u0015\u00a2\u0006\u0002\b\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010PR\u0014\u0010S\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\u00a8\u0006Y"}, d2={"Lqrcode/QRCodeBuilder;", "", "shape", "Lqrcode/QRCodeShapesEnum;", "customShapeFunction", "Lqrcode/shape/QRCodeShapeFunction;", "<init>", "(Lqrcode/QRCodeShapesEnum;Lqrcode/shape/QRCodeShapeFunction;)V", "customColorFunction", "Lqrcode/color/QRCodeColorFunction;", "squareSize", "", "color", "endColor", "Ljava/lang/Integer;", "vertical", "", "background", "innerSpace", "radiusInPixels", "drawLogoAction", "Lkotlin/Function4;", "Lqrcode/QRCode;", "Lqrcode/render/QRCodeGraphics;", "", "Lkotlin/ExtensionFunctionType;", "drawLogoBeforeAction", "userDoAfter", "userDoBefore", "graphicsFactory", "Lqrcode/render/QRCodeGraphicsFactory;", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "informationDensity", "maskPattern", "Lqrcode/raw/MaskPattern;", "canvasSize", "xOffset", "yOffset", "margin", "withShape", "withSize", "size", "withColor", "withBackgroundColor", "bgColor", "withGradientColor", "startColor", "(ILjava/lang/Integer;Z)Lqrcode/QRCodeBuilder;", "withRadius", "radius", "withInnerSpacing", "innerSpacing", "(Ljava/lang/Integer;)Lqrcode/QRCodeBuilder;", "withLogo", "logo", "", "width", "height", "clearLogoArea", "withAfterRenderAction", "action", "Lkotlin/Function2;", "withBeforeRenderAction", "withGraphicsFactory", "factory", "withCustomColorFunction", "colorFn", "withCustomShapeFunction", "shapeFn", "withErrorCorrectionLevel", "ecl", "withInformationDensity", "withMaskPattern", "withCanvasSize", "withXOffset", "withYOffset", "withMargin", "beforeFn", "getBeforeFn", "()Lkotlin/jvm/functions/Function4;", "afterFn", "getAfterFn", "colorFunction", "getColorFunction", "()Lqrcode/color/QRCodeColorFunction;", "build", "data", "", "qrcode-kotlin"})
@SourceDebugExtension(value={"SMAP\nQRCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCodeBuilder.kt\nqrcode/QRCodeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,389:1\n1#2:390\n13472#3:391\n13472#3,2:392\n13473#3:394\n*S KotlinDebug\n*F\n+ 1 QRCodeBuilder.kt\nqrcode/QRCodeBuilder\n*L\n149#1:391\n150#1:392,2\n149#1:394\n*E\n"})
public final class QRCodeBuilder {
    @NotNull
    private QRCodeShapesEnum shape;
    @Nullable
    private QRCodeShapeFunction customShapeFunction;
    @Nullable
    private QRCodeColorFunction customColorFunction;
    private int squareSize;
    private int color;
    @Nullable
    private Integer endColor;
    private boolean vertical;
    private int background;
    private int innerSpace;
    private int radiusInPixels;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> drawLogoAction;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> drawLogoBeforeAction;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> userDoAfter;
    @NotNull
    private Function4<? super QRCode, ? super QRCodeGraphics, ? super Integer, ? super Integer, Unit> userDoBefore;
    @NotNull
    private QRCodeGraphicsFactory graphicsFactory;
    @NotNull
    private ErrorCorrectionLevel errorCorrectionLevel;
    private int informationDensity;
    @NotNull
    private MaskPattern maskPattern;
    private int canvasSize;
    private int xOffset;
    private int yOffset;
    private int margin;

    @JvmOverloads
    public QRCodeBuilder(@NotNull QRCodeShapesEnum shape, @Nullable QRCodeShapeFunction customShapeFunction) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this.shape = shape;
        this.customShapeFunction = customShapeFunction;
        this.squareSize = 25;
        this.color = -16777216;
        this.vertical = true;
        this.innerSpace = this.innerSpace();
        this.radiusInPixels = RoundSquaresShapeFunction.Companion.defaultRadius(this.squareSize);
        this.drawLogoAction = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.drawLogoBeforeAction = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.userDoAfter = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.userDoBefore = QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
        this.graphicsFactory = new QRCodeGraphicsFactory();
        this.errorCorrectionLevel = ErrorCorrectionLevel.LOW;
        this.maskPattern = MaskPattern.PATTERN000;
    }

    public /* synthetic */ QRCodeBuilder(QRCodeShapesEnum qRCodeShapesEnum, QRCodeShapeFunction qRCodeShapeFunction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            qRCodeShapeFunction = null;
        }
        this(qRCodeShapesEnum, qRCodeShapeFunction);
    }

    private final int innerSpace() {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = CircleShapeFunction.Companion.defaultInnerSpace(this.squareSize);
                break;
            }
            case 3: {
                n = RoundSquaresShapeFunction.Companion.defaultInnerSpace(this.squareSize);
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = it < this.squareSize ? n2 : null;
        return n3 != null ? n3 : 0;
    }

    @NotNull
    public final QRCodeBuilder withShape(@NotNull QRCodeShapesEnum shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this.shape = shape;
        return this.withInnerSpacing(this.innerSpace());
    }

    @NotNull
    public final QRCodeBuilder withSize(int size) {
        this.squareSize = RangesKt.coerceAtLeast((int)size, (int)1);
        return this.withInnerSpacing(this.innerSpace());
    }

    @NotNull
    public final QRCodeBuilder withColor(int color) {
        this.color = color;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withBackgroundColor(int bgColor) {
        this.background = bgColor;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withGradientColor(int startColor, @Nullable Integer endColor, boolean vertical) {
        this.color = startColor;
        this.endColor = endColor;
        this.vertical = vertical;
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withGradientColor$default(QRCodeBuilder qRCodeBuilder, int n, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return qRCodeBuilder.withGradientColor(n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QRCodeBuilder withRadius(int radius) {
        void it;
        Integer n = radius;
        int n2 = ((Number)n).intValue();
        QRCodeBuilder qRCodeBuilder = this;
        boolean bl = false;
        boolean bl2 = it >= 0;
        Integer n3 = bl2 ? n : null;
        qRCodeBuilder.radiusInPixels = n3 != null ? n3.intValue() : RoundSquaresShapeFunction.Companion.defaultRadius(this.squareSize);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withInnerSpacing(@Nullable Integer innerSpacing) {
        v0 = this;
        v1 = innerSpacing;
        if (v1 == null) ** GOTO lbl-1000
        var2_2 = v1;
        var3_3 = ((Number)var2_2).intValue();
        var5_4 = v0;
        $i$a$-takeIf-QRCodeBuilder$withInnerSpacing$1 = false;
        var6_6 = it >= 0;
        v0 = var5_4;
        v1 = var6_6 != false ? var2_2 : null;
        if (v1 != null) {
            v2 = v1;
        } else lbl-1000:
        // 2 sources

        {
            v2 = this.innerSpace();
        }
        v0.innerSpace = v2;
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withInnerSpacing$default(QRCodeBuilder qRCodeBuilder, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return qRCodeBuilder.withInnerSpacing(n);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withLogo(@Nullable byte[] logo, int width, int height, boolean clearLogoArea) {
        if (logo != null) {
            this.drawLogoBeforeAction = clearLogoArea ? (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder.withLogo$lambda$5(width, height, arg_0, arg_1, arg_2, arg_3) : QRCode.Companion.getEMPTY_FN$qrcode_kotlin();
            this.drawLogoAction = (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder.withLogo$lambda$6(width, height, logo, arg_0, arg_1, arg_2, arg_3);
        }
        return this;
    }

    public static /* synthetic */ QRCodeBuilder withLogo$default(QRCodeBuilder qRCodeBuilder, byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return qRCodeBuilder.withLogo(byArray, n, n2, bl);
    }

    @NotNull
    public final QRCodeBuilder withAfterRenderAction(@NotNull Function2<? super QRCode, ? super QRCodeGraphics, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.userDoAfter = (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder.withAfterRenderAction$lambda$7(action, arg_0, arg_1, arg_2, arg_3);
        return this;
    }

    @NotNull
    public final QRCodeBuilder withBeforeRenderAction(@NotNull Function2<? super QRCode, ? super QRCodeGraphics, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.userDoBefore = (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder.withBeforeRenderAction$lambda$8(action, arg_0, arg_1, arg_2, arg_3);
        return this;
    }

    @NotNull
    public final QRCodeBuilder withGraphicsFactory(@NotNull QRCodeGraphicsFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.graphicsFactory = factory;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withCustomColorFunction(@Nullable QRCodeColorFunction colorFn) {
        this.customColorFunction = colorFn;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withCustomShapeFunction(@Nullable QRCodeShapeFunction shapeFn) {
        this.customShapeFunction = shapeFn;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withErrorCorrectionLevel(@NotNull ErrorCorrectionLevel ecl) {
        Intrinsics.checkNotNullParameter((Object)((Object)ecl), (String)"ecl");
        this.errorCorrectionLevel = ecl;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withInformationDensity(int informationDensity) {
        this.informationDensity = RangesKt.coerceIn((int)informationDensity, (ClosedRange)((ClosedRange)new IntRange(0, 40)));
        return this;
    }

    @NotNull
    public final QRCodeBuilder withMaskPattern(@NotNull MaskPattern maskPattern) {
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        this.maskPattern = maskPattern;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withCanvasSize(int size) {
        this.canvasSize = size;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withXOffset(int xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withYOffset(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    @NotNull
    public final QRCodeBuilder withMargin(int margin) {
        this.margin = margin;
        return this;
    }

    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> getBeforeFn() {
        return (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder._get_beforeFn_$lambda$9(this, arg_0, arg_1, arg_2, arg_3);
    }

    private final Function4<QRCode, QRCodeGraphics, Integer, Integer, Unit> getAfterFn() {
        return (arg_0, arg_1, arg_2, arg_3) -> QRCodeBuilder._get_afterFn_$lambda$10(this, arg_0, arg_1, arg_2, arg_3);
    }

    private final QRCodeColorFunction getColorFunction() {
        QRCodeColorFunction qRCodeColorFunction;
        if (this.endColor == null) {
            qRCodeColorFunction = this.customColorFunction;
            if (qRCodeColorFunction == null) {
                qRCodeColorFunction = new DefaultColorFunction(this.color, this.background);
            }
        } else {
            qRCodeColorFunction = this.customColorFunction;
            if (qRCodeColorFunction == null) {
                Integer n = this.endColor;
                Intrinsics.checkNotNull((Object)n);
                qRCodeColorFunction = new LinearGradientColorFunction(this.color, n, this.background, false, 8, null);
            }
        }
        return qRCodeColorFunction;
    }

    @NotNull
    public final QRCode build(@NotNull String data) {
        QRCode qRCode;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        QRCodeColorFunction qRCodeColorFunction = this.getColorFunction();
        QRCodeShapeFunction qRCodeShapeFunction = this.customShapeFunction;
        if (qRCodeShapeFunction == null) {
            DefaultShapeFunction defaultShapeFunction;
            switch (WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
                case 1: 
                case 4: {
                    defaultShapeFunction = new DefaultShapeFunction(this.squareSize, this.innerSpace);
                    break;
                }
                case 2: {
                    defaultShapeFunction = new CircleShapeFunction(this.squareSize, this.innerSpace);
                    break;
                }
                case 3: {
                    defaultShapeFunction = new RoundSquaresShapeFunction(this.squareSize, this.radiusInPixels, this.innerSpace);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            qRCodeShapeFunction = defaultShapeFunction;
        }
        QRCode $this$build_u24lambda_u2411 = qRCode = new QRCode(data, this.squareSize, this.canvasSize, this.xOffset + this.margin, this.yOffset + this.margin, qRCodeColorFunction, qRCodeShapeFunction, this.graphicsFactory, this.errorCorrectionLevel, this.informationDensity == 0 ? QRCodeProcessor.Companion.infoDensityForDataAndECL$default(QRCodeProcessor.Companion, data, this.errorCorrectionLevel, null, 4, null) : this.informationDensity, this.maskPattern, this.getBeforeFn(), this.getAfterFn());
        boolean bl = false;
        if (this.margin > 0) {
            $this$build_u24lambda_u2411.resize($this$build_u24lambda_u2411.getCanvasSize() + this.margin * 2);
        }
        return qRCode;
    }

    @JvmOverloads
    public QRCodeBuilder(@NotNull QRCodeShapesEnum shape) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        this(shape, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withGradientColor(int startColor, @Nullable Integer endColor) {
        return QRCodeBuilder.withGradientColor$default(this, startColor, endColor, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withInnerSpacing() {
        return QRCodeBuilder.withInnerSpacing$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QRCodeBuilder withLogo(@Nullable byte[] logo, int width, int height) {
        return QRCodeBuilder.withLogo$default(this, logo, width, height, false, 8, null);
    }

    private static final Unit withLogo$lambda$5(int $width, int $height, QRCode qRCode, QRCodeGraphics qRCodeGraphics, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)qRCodeGraphics, (String)"<unused var>");
        int logoX = (qRCode.getCanvasSize() - $width) / 2;
        int logoY = (qRCode.getCanvasSize() - $height) / 2;
        Object[] $this$forEach$iv = (Object[])qRCode.getRawData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QRCodeSquare[] row = (QRCodeSquare[])element$iv;
            boolean bl = false;
            QRCodeSquare[] $this$forEach$iv2 = row;
            boolean $i$f$forEach2 = false;
            int n3 = $this$forEach$iv2.length;
            for (int i = 0; i < n3; ++i) {
                int cellY;
                QRCodeSquare element$iv2;
                QRCodeSquare cell = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                int cellX = cell.absoluteX(qRCode.getSquareSize());
                cell.setRendered(!QRMath.INSTANCE.rectsIntersect(logoX, logoY, $width, $height, cellX, cellY = cell.absoluteY(qRCode.getSquareSize()), qRCode.getSquareSize(), qRCode.getSquareSize()));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit withLogo$lambda$6(int $width, int $height, byte[] $logo, QRCode qRCode, QRCodeGraphics canvas, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int logoX = xOffset + (qRCode.getCanvasSize() - $width) / 2;
        int logoY = yOffset + (qRCode.getCanvasSize() - $height) / 2;
        canvas.drawImage($logo, logoX, logoY);
        return Unit.INSTANCE;
    }

    private static final Unit withAfterRenderAction$lambda$7(Function2 $action, QRCode qRCode, QRCodeGraphics it, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke((Object)qRCode, (Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit withBeforeRenderAction$lambda$8(Function2 $action, QRCode qRCode, QRCodeGraphics it, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $action.invoke((Object)qRCode, (Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _get_beforeFn_$lambda$9(QRCodeBuilder this$0, QRCode qRCode, QRCodeGraphics canvas, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this$0.drawLogoBeforeAction.invoke((Object)qRCode, (Object)canvas, (Object)xOffset, (Object)yOffset);
        this$0.userDoBefore.invoke((Object)qRCode, (Object)canvas, (Object)xOffset, (Object)yOffset);
        return Unit.INSTANCE;
    }

    private static final Unit _get_afterFn_$lambda$10(QRCodeBuilder this$0, QRCode qRCode, QRCodeGraphics canvas, int xOffset, int yOffset) {
        Intrinsics.checkNotNullParameter((Object)qRCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this$0.drawLogoAction.invoke((Object)qRCode, (Object)canvas, (Object)xOffset, (Object)yOffset);
        this$0.userDoAfter.invoke((Object)qRCode, (Object)canvas, (Object)xOffset, (Object)yOffset);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeShapesEnum.values().length];
            try {
                nArray[QRCodeShapesEnum.SQUARE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.CIRCLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.ROUNDED_SQUARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QRCodeShapesEnum.CUSTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

