/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0082\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000fH\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lqrcode/internals/BitBuffer;", "", "<init>", "()V", "value", "", "buffer", "getBuffer", "()[I", "", "lengthInBits", "getLengthInBits", "()I", "increments", "get", "", "index", "put", "", "num", "length", "bit", "toString", "", "qrcode-kotlin"})
public final class BitBuffer {
    @NotNull
    private int[] buffer;
    private int lengthInBits;
    private final int increments;

    public BitBuffer() {
        this.increments = 32;
        this.buffer = new int[this.increments];
        this.lengthInBits = 0;
    }

    @NotNull
    public final int[] getBuffer() {
        return this.buffer;
    }

    public final int getLengthInBits() {
        return this.lengthInBits;
    }

    private final boolean get(int index) {
        return (this.buffer[index / 8] >>> 7 - index % 8 & 1) == 1;
    }

    public final void put(int num, int length) {
        for (int i = 0; i < length; ++i) {
            this.put((num >>> length - i - 1 & 1) == 1);
        }
    }

    public final void put(boolean bit) {
        if (this.lengthInBits == this.buffer.length * 8) {
            int[] nArray = Arrays.copyOf(this.buffer, this.buffer.length + this.increments);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.buffer = nArray;
        }
        if (bit) {
            this.buffer[this.lengthInBits / 8] = this.buffer[this.lengthInBits / 8] | 128 >>> this.lengthInBits % 8;
        }
        int n = this.lengthInBits;
        this.lengthInBits = n + 1;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int n = this.lengthInBits;
        for (int i = 0; i < n; ++i) {
            buffer.append(this.get(i) ? (char)'1' : '0');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

