/*
 * Decompiled with CFR 0.152.
 */
package qrcode.internals;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import qrcode.internals.QRCodeRegion;
import qrcode.internals.QRCodeSquare;
import qrcode.internals.QRCodeSquareInfo;
import qrcode.internals.QRCodeSquareType;
import qrcode.internals.QRUtil;
import qrcode.raw.ErrorCorrectionLevel;
import qrcode.raw.MaskPattern;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ+\u0010\r\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ+\u0010\u000e\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ;\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J)\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t\u00a2\u0006\u0002\u0010\u001fJ9\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t\u00a2\u0006\u0002\u0010'J1\u0010(\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t\u00a2\u0006\u0002\u0010)J9\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u00052\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t\u00a2\u0006\u0002\u0010-JG\u0010.\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00142\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\t2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lqrcode/internals/QRCodeSetup;", "", "<init>", "()V", "DEFAULT_PROBE_SIZE", "", "setupTopLeftPositionProbePattern", "", "modules", "", "Lqrcode/internals/QRCodeSquare;", "probeSize", "([[Lqrcode/internals/QRCodeSquare;I)V", "setupTopRightPositionProbePattern", "setupBottomLeftPositionProbePattern", "setupPositionProbePattern", "rowOffset", "colOffset", "(II[[Lqrcode/internals/QRCodeSquare;I)V", "isInsideModules", "", "row", "col", "modulesSize", "isTopBottomRowSquare", "isLeftRightColSquare", "isMidSquare", "findSquareRegion", "Lqrcode/internals/QRCodeRegion;", "setupPositionAdjustPattern", "type", "(I[[Lqrcode/internals/QRCodeSquare;)V", "setupTimingPattern", "moduleCount", "setupTypeInfo", "errorCorrectionLevel", "Lqrcode/raw/ErrorCorrectionLevel;", "maskPattern", "Lqrcode/raw/MaskPattern;", "(Lqrcode/raw/ErrorCorrectionLevel;Lqrcode/raw/MaskPattern;I[[Lqrcode/internals/QRCodeSquare;)V", "setupTypeNumber", "(II[[Lqrcode/internals/QRCodeSquare;)V", "applyMaskPattern", "data", "", "([ILqrcode/raw/MaskPattern;I[[Lqrcode/internals/QRCodeSquare;)V", "set", "value", "parent", "(IIZ[[Lqrcode/internals/QRCodeSquare;Lqrcode/internals/QRCodeSquare;)V", "qrcode-kotlin"})
public final class QRCodeSetup {
    @NotNull
    public static final QRCodeSetup INSTANCE = new QRCodeSetup();
    private static final int DEFAULT_PROBE_SIZE = 7;

    private QRCodeSetup() {
    }

    public final void setupTopLeftPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        this.setupPositionProbePattern(0, 0, modules, probeSize);
    }

    public static /* synthetic */ void setupTopLeftPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupTopLeftPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupTopRightPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        this.setupPositionProbePattern(((Object[])modules).length - probeSize, 0, modules, probeSize);
    }

    public static /* synthetic */ void setupTopRightPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupTopRightPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupBottomLeftPositionProbePattern(@NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        this.setupPositionProbePattern(0, ((Object[])modules).length - probeSize, modules, probeSize);
    }

    public static /* synthetic */ void setupBottomLeftPositionProbePattern$default(QRCodeSetup qRCodeSetup, QRCodeSquare[][] qRCodeSquareArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 7;
        }
        qRCodeSetup.setupBottomLeftPositionProbePattern(qRCodeSquareArray, n);
    }

    public final void setupPositionProbePattern(int rowOffset, int colOffset, @NotNull QRCodeSquare[][] modules, int probeSize) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int modulesSize = ((Object[])modules).length;
        QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_PROBE, QRCodeRegion.UNKNOWN);
        QRCodeSquare squareData = new QRCodeSquare(false, rowOffset, colOffset, modulesSize, qRCodeSquareInfo, probeSize, probeSize, null, 128, null);
        int row = -1;
        if (row <= probeSize) {
            while (true) {
                int col;
                if ((col = -1) <= probeSize) {
                    while (true) {
                        if (this.isInsideModules(row, rowOffset, col, colOffset, modulesSize)) {
                            boolean isDark = this.isTopBottomRowSquare(row, col, probeSize) || this.isLeftRightColSquare(row, col, probeSize) || this.isMidSquare(row, col, probeSize);
                            QRCodeRegion region = this.findSquareRegion(row, col, probeSize);
                            int n = row + rowOffset;
                            int n2 = col + colOffset;
                            QRCodeSquareInfo qRCodeSquareInfo2 = new QRCodeSquareInfo(QRCodeSquareType.POSITION_PROBE, region);
                            modules[row + rowOffset][col + colOffset] = new QRCodeSquare(isDark, n, n2, modulesSize, qRCodeSquareInfo2, 0, 0, squareData, 96, null);
                        }
                        if (col == probeSize) break;
                        ++col;
                    }
                }
                if (row == probeSize) break;
                ++row;
            }
        }
    }

    public static /* synthetic */ void setupPositionProbePattern$default(QRCodeSetup qRCodeSetup, int n, int n2, QRCodeSquare[][] qRCodeSquareArray, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 7;
        }
        qRCodeSetup.setupPositionProbePattern(n, n2, qRCodeSquareArray, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideModules(int row, int rowOffset, int col, int colOffset, int modulesSize) {
        int n = row + rowOffset;
        if (0 > n) return false;
        if (n >= modulesSize) return false;
        boolean bl = true;
        if (!bl) return false;
        n = col + colOffset;
        if (0 > n) return false;
        if (n >= modulesSize) return false;
        return true;
    }

    private final boolean isTopBottomRowSquare(int row, int col, int probeSize) {
        return (0 <= col ? col < probeSize : false) && (row == 0 || row == probeSize - 1);
    }

    private final boolean isLeftRightColSquare(int row, int col, int probeSize) {
        return (0 <= row ? row < probeSize : false) && (col == 0 || col == probeSize - 1);
    }

    private final boolean isMidSquare(int row, int col, int probeSize) {
        return (2 <= row ? row < probeSize - 2 : false) && 2 <= col && col <= probeSize - 3;
    }

    private final QRCodeRegion findSquareRegion(int row, int col, int probeSize) {
        int n;
        int n2;
        int n3;
        int n4 = row;
        QRCodeRegion qRCodeRegion = n4 == 0 ? ((n3 = col) == 0 ? QRCodeRegion.TOP_LEFT_CORNER : (n3 == probeSize - 1 ? QRCodeRegion.TOP_RIGHT_CORNER : (n3 == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.TOP_MID))) : (n4 == probeSize - 1 ? ((n2 = col) == 0 ? QRCodeRegion.BOTTOM_LEFT_CORNER : (n2 == probeSize - 1 ? QRCodeRegion.BOTTOM_RIGHT_CORNER : (n2 == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.BOTTOM_MID))) : (n4 == probeSize ? QRCodeRegion.MARGIN : ((n = col) == 0 ? QRCodeRegion.LEFT_MID : (n == probeSize - 1 ? QRCodeRegion.RIGHT_MID : (n == probeSize ? QRCodeRegion.MARGIN : QRCodeRegion.CENTER)))));
        return qRCodeRegion;
    }

    public final void setupPositionAdjustPattern(int type, @NotNull QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int[] pos = QRUtil.INSTANCE.getPatternPosition(type);
        int n = pos.length;
        for (int i = 0; i < n; ++i) {
            int n2 = pos.length;
            for (int j = 0; j < n2; ++j) {
                int row = pos[i];
                int col = pos[j];
                if (modules[row][col] != null) continue;
                int n3 = row - 2;
                int n4 = col - 2;
                QRCodeSquareInfo qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.POSITION_ADJUST, QRCodeRegion.UNKNOWN);
                int n5 = ((Object[])modules).length;
                QRCodeSquare squareData = new QRCodeSquare(false, n3, n4, n5, qRCodeSquareInfo, 6, 6, null, 128, null);
                for (int r = -2; r < 3; ++r) {
                    for (int c = -2; c < 3; ++c) {
                        boolean bl = r == -2 || r == 2 || c == -2 || c == 2 || r == 0 && c == 0;
                        n5 = row + r;
                        int n6 = col + c;
                        QRCodeSquareInfo qRCodeSquareInfo2 = new QRCodeSquareInfo(QRCodeSquareType.POSITION_ADJUST, QRCodeRegion.UNKNOWN);
                        int n7 = ((Object[])modules).length;
                        modules[row + r][col + c] = new QRCodeSquare(bl, n5, n6, n7, qRCodeSquareInfo2, 0, 0, squareData, 96, null);
                    }
                }
            }
        }
    }

    public final void setupTimingPattern(int moduleCount, @NotNull QRCodeSquare[][] modules) {
        int n;
        QRCodeSquareInfo qRCodeSquareInfo;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int n2 = moduleCount - 8;
        for (int r = 8; r < n2; ++r) {
            if (modules[r][6] != null) continue;
            bl = r % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n = ((Object[])modules).length;
            modules[r][6] = new QRCodeSquare(bl, r, 6, n, qRCodeSquareInfo, 0, 0, null, 96, null);
        }
        n2 = moduleCount - 8;
        for (int c = 8; c < n2; ++c) {
            if (modules[6][c] != null) continue;
            bl = c % 2 == 0;
            qRCodeSquareInfo = new QRCodeSquareInfo(QRCodeSquareType.TIMING_PATTERN, QRCodeRegion.UNKNOWN);
            n = ((Object[])modules).length;
            modules[6][c] = new QRCodeSquare(bl, 6, c, n, qRCodeSquareInfo, 0, 0, null, 96, null);
        }
    }

    public final void setupTypeInfo(@NotNull ErrorCorrectionLevel errorCorrectionLevel, @NotNull MaskPattern maskPattern, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        boolean mod;
        int i;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCorrectionLevel), (String)"errorCorrectionLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int data = errorCorrectionLevel.getValue() << 3 | maskPattern.ordinal();
        int bits = QRUtil.INSTANCE.getBCHTypeInfo(data);
        for (i = 0; i < 15; ++i) {
            boolean bl = mod = (bits >> i & 1) == 1;
            if (i < 6) {
                QRCodeSetup.set$default(this, i, 8, mod, modules, null, 16, null);
                continue;
            }
            if (i < 8) {
                QRCodeSetup.set$default(this, i + 1, 8, mod, modules, null, 16, null);
                continue;
            }
            QRCodeSetup.set$default(this, moduleCount - 15 + i, 8, mod, modules, null, 16, null);
        }
        for (i = 0; i < 15; ++i) {
            boolean bl = mod = (bits >> i & 1) == 1;
            if (i < 8) {
                QRCodeSetup.set$default(this, 8, moduleCount - i - 1, mod, modules, null, 16, null);
                continue;
            }
            if (i < 9) {
                QRCodeSetup.set$default(this, 8, 15 - i, mod, modules, null, 16, null);
                continue;
            }
            QRCodeSetup.set$default(this, 8, 15 - i - 1, mod, modules, null, 16, null);
        }
        QRCodeSetup.set$default(this, moduleCount - 8, 8, true, modules, null, 16, null);
    }

    public final void setupTypeNumber(int type, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        boolean mod;
        int i;
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int bits = QRUtil.INSTANCE.getBCHTypeNumber(type);
        for (i = 0; i < 18; ++i) {
            mod = (bits >> i & 1) == 1;
            QRCodeSetup.set$default(this, i / 3, i % 3 + moduleCount - 8 - 3, mod, modules, null, 16, null);
        }
        for (i = 0; i < 18; ++i) {
            mod = (bits >> i & 1) == 1;
            QRCodeSetup.set$default(this, i % 3 + moduleCount - 8 - 3, i / 3, mod, modules, null, 16, null);
        }
    }

    public final void applyMaskPattern(@NotNull int[] data, @NotNull MaskPattern maskPattern, int moduleCount, @NotNull QRCodeSquare[][] modules) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)maskPattern), (String)"maskPattern");
        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
        int inc = -1;
        int bitIndex = 7;
        int byteIndex = 0;
        int row = moduleCount - 1;
        for (int col = moduleCount - 1; col > 0; col -= 2) {
            if (col == 6) {
                --col;
            }
            do {
                for (int c = 0; c < 2; ++c) {
                    boolean mask;
                    if (modules[row][col - c] != null) continue;
                    boolean dark = false;
                    if (byteIndex < data.length) {
                        boolean bl = dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                    }
                    if (mask = QRUtil.INSTANCE.getMask(maskPattern, row, col - c)) {
                        dark = !dark;
                    }
                    QRCodeSetup.set$default(this, row, col - c, dark, modules, null, 16, null);
                    if (--bitIndex != -1) continue;
                    ++byteIndex;
                    bitIndex = 7;
                }
            } while ((row += inc) >= 0 && moduleCount > row);
            row -= inc;
            inc = -inc;
        }
    }

    private final void set(int row, int col, boolean value, QRCodeSquare[][] modules, QRCodeSquare parent) {
        QRCodeSquare qrCodeSquare = modules[row][col];
        if (qrCodeSquare != null) {
            qrCodeSquare.setDark(value);
        } else {
            modules[row][col] = new QRCodeSquare(value, row, col, ((Object[])modules).length, null, 0, 0, parent, 112, null);
        }
    }

    static /* synthetic */ void set$default(QRCodeSetup qRCodeSetup, int n, int n2, boolean bl, QRCodeSquare[][] qRCodeSquareArray, QRCodeSquare qRCodeSquare, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            qRCodeSquare = null;
        }
        qRCodeSetup.set(n, n2, bl, qRCodeSquareArray, qRCodeSquare);
    }
}

