/*
 * Decompiled with CFR 0.152.
 */
package qrcode.shape;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import qrcode.QRCode;
import qrcode.color.QRCodeColorFunction;
import qrcode.internals.QRCodeSquare;
import qrcode.internals.QRCodeSquareType;
import qrcode.render.QRCodeGraphics;
import qrcode.shape.QRCodeShapeFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J8\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010!\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J@\u0010$\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006'"}, d2={"Lqrcode/shape/DefaultShapeFunction;", "Lqrcode/shape/QRCodeShapeFunction;", "squareSize", "", "innerSpace", "<init>", "(II)V", "getInnerSpace", "()I", "innerSpacing", "value", "getSquareSize", "resize", "", "newSquareSize", "renderSquare", "x", "y", "colorFn", "Lqrcode/color/QRCodeColorFunction;", "square", "Lqrcode/internals/QRCodeSquare;", "canvas", "Lqrcode/render/QRCodeGraphics;", "qrCode", "Lqrcode/QRCode;", "renderControlSquare", "xOffset", "yOffset", "drawSquaresLine", "amount", "skip", "color", "fillRect", "width", "height", "drawRect", "thickness", "", "qrcode-kotlin"})
public class DefaultShapeFunction
implements QRCodeShapeFunction {
    private final int innerSpace;
    private int innerSpacing;
    private int squareSize;

    public DefaultShapeFunction(int squareSize, int innerSpace) {
        this.innerSpace = innerSpace;
        this.innerSpacing = RangesKt.coerceIn((int)this.innerSpace, (ClosedRange)((ClosedRange)new IntRange(0, squareSize / 2)));
        this.squareSize = squareSize;
    }

    public /* synthetic */ DefaultShapeFunction(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 25;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(n, n2);
    }

    public final int getInnerSpace() {
        return this.innerSpace;
    }

    public final int getSquareSize() {
        return this.squareSize;
    }

    @Override
    public void resize(int newSquareSize) {
        double sizeRatio = (double)newSquareSize / (double)this.squareSize;
        this.squareSize = newSquareSize;
        this.innerSpacing = RangesKt.coerceIn((int)((int)((double)this.innerSpace * sizeRatio)), (ClosedRange)((ClosedRange)new IntRange(0, newSquareSize / 2)));
    }

    @Override
    public void renderSquare(int x, int y, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeSquare square, @NotNull QRCodeGraphics canvas, @NotNull QRCode qrCode) {
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)square, (String)"square");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)qrCode, (String)"qrCode");
        int bg = colorFn.bg(square.getRow(), square.getCol(), qrCode, canvas);
        int fg = colorFn.fg(square.getRow(), square.getCol(), qrCode, canvas);
        int color = square.getDark() ? fg : bg;
        this.fillRect(x + this.innerSpacing, y + this.innerSpacing, this.squareSize - this.innerSpacing * 2, this.squareSize - this.innerSpacing * 2, color, canvas);
    }

    @Override
    public void renderControlSquare(int xOffset, int yOffset, @NotNull QRCodeColorFunction colorFn, @NotNull QRCodeSquare square, @NotNull QRCodeGraphics canvas, @NotNull QRCode qrCode) {
        Intrinsics.checkNotNullParameter((Object)colorFn, (String)"colorFn");
        Intrinsics.checkNotNullParameter((Object)square, (String)"square");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)qrCode, (String)"qrCode");
        QRCodeSquare qRCodeSquare = square.getParent();
        if (qRCodeSquare == null) {
            qRCodeSquare = square;
        }
        QRCodeSquare actualSquare = qRCodeSquare;
        int bg = colorFn.bg(actualSquare.getRow(), actualSquare.getCol(), qrCode, canvas);
        int fg = colorFn.fg(actualSquare.getRow(), actualSquare.getCol(), qrCode, canvas);
        int size = this.squareSize * actualSquare.getRowSize();
        int startX = xOffset + actualSquare.absoluteX(this.squareSize);
        int startY = yOffset + actualSquare.absoluteY(this.squareSize);
        if (WhenMappings.$EnumSwitchMapping$0[actualSquare.getSquareInfo().getType().ordinal()] == 1) {
            canvas.fillRect(startX, startY, size + this.squareSize * 2, size + this.squareSize * 2, bg);
            this.drawRect(startX + this.innerSpacing, startY + this.innerSpacing, size - this.innerSpacing * 2, size - this.innerSpacing * 2, fg, this.squareSize, canvas);
            this.fillRect(startX + this.squareSize * 2, startY + this.squareSize * 2, size - this.squareSize * 4, size - this.squareSize * 4, fg, canvas);
        } else {
            canvas.fillRect(startX, startY, size, size, bg);
            this.drawSquaresLine(startX, startY, 5, 1, fg, canvas);
            this.drawSquaresLine(startX, startY + this.squareSize, 5, 4, fg, canvas);
            this.drawSquaresLine(startX, startY + this.squareSize * 2, 5, 2, fg, canvas);
            this.drawSquaresLine(startX, startY + this.squareSize * 3, 5, 4, fg, canvas);
            this.drawSquaresLine(startX, startY + this.squareSize * 4, 5, 1, fg, canvas);
        }
    }

    private final void drawSquaresLine(int x, int y, int amount, int skip, int color, QRCodeGraphics canvas) {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)amount)), (int)skip);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                this.fillRect(x + this.squareSize * i + this.innerSpacing, y + this.innerSpacing, this.squareSize - this.innerSpacing * 2, this.squareSize - this.innerSpacing * 2, color, canvas);
                if (i == n) break;
                i += n2;
            }
        }
    }

    public void fillRect(int x, int y, int width, int height, int color, @NotNull QRCodeGraphics canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.fillRect(x, y, width, height, color);
    }

    public void drawRect(int x, int y, int width, int height, int color, double thickness, @NotNull QRCodeGraphics canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.drawRect(x, y, width, height, color, thickness);
    }

    @Override
    public void beforeRender(@NotNull QRCode qrCode, @NotNull QRCodeGraphics qrCodeGraphics) {
        QRCodeShapeFunction.DefaultImpls.beforeRender(this, qrCode, qrCodeGraphics);
    }

    public DefaultShapeFunction() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QRCodeSquareType.values().length];
            try {
                nArray[QRCodeSquareType.POSITION_PROBE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

