/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.model.Ulimit;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Objects;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class CephContainer
extends GenericContainer<CephContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"quay.io/ceph/demo");
    private static final String DEFAULT_IMAGE_TAG = "latest-quincy";
    private static final String CEPH_RGW_DEFAULT_ACCESS_KEY = "demo";
    private static final String CEPH_RGW_DEFAULT_SECRET_KEY = "b36361c4-1589-42f7-a369-d9dafb926d55";
    private static final Integer CEPH_MON_DEFAULT_PORT = 3300;
    private static final Integer CEPH_RGW_DEFAULT_PORT = 8080;
    private static final String CEPH_DEMO_UID = "demo";
    private static final String CEPH_DEMO_BUCKET = "demo";
    private static final String CEPH_END_START_REGEX_FORMAT = ".*Bucket 's3://%s/' created\n.*";
    private static final Ulimit[] DEFAULT_ULIMITS = new Ulimit[]{new Ulimit("nofile", 65536L, 65536L)};
    private String cephAccessKey;
    private String cephSecretKey;
    private String cephBucket;

    public CephContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_IMAGE_TAG));
    }

    public CephContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CephContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withCreateContainerCmdModifier(createContainerCmd -> Objects.requireNonNull(createContainerCmd.getHostConfig()).withUlimits(DEFAULT_ULIMITS));
    }

    public void configure() {
        this.addExposedPorts(new int[]{CEPH_MON_DEFAULT_PORT, CEPH_RGW_DEFAULT_PORT});
        this.addEnv("CEPH_DEMO_UID", "demo");
        this.addEnv("CEPH_DEMO_BUCKET", this.cephBucket != null ? this.cephBucket : (this.cephBucket = "demo"));
        this.addEnv("CEPH_DEMO_ACCESS_KEY", this.cephAccessKey != null ? this.cephAccessKey : (this.cephAccessKey = "demo"));
        this.addEnv("CEPH_DEMO_SECRET_KEY", this.cephSecretKey != null ? this.cephSecretKey : (this.cephSecretKey = CEPH_RGW_DEFAULT_SECRET_KEY));
        this.addEnv("CEPH_PUBLIC_NETWORK", "0.0.0.0/0");
        this.addEnv("MON_IP", "127.0.0.1");
        this.addEnv("RGW_NAME", "localhost");
        if (this.waitStrategy == DEFAULT_WAIT_STRATEGY) {
            this.setWaitStrategy(Wait.forLogMessage((String)String.format(CEPH_END_START_REGEX_FORMAT, this.cephBucket), (int)1).withStartupTimeout(Duration.ofMinutes(5L)));
        }
    }

    public CephContainer withSslDisabled() {
        return (CephContainer)super.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"bash", "-c", "sed -i '/^rgw frontends = .*/a rgw verify ssl = false\\\nrgw crypt require ssl = false' /opt/ceph-container/bin/demo;\n/opt/ceph-container/bin/demo;"}));
    }

    public CephContainer withCephAccessKey(String cephAccessKey) {
        this.cephAccessKey = cephAccessKey;
        return this;
    }

    public CephContainer withCephSecretKey(String cephSecretKey) {
        this.cephSecretKey = cephSecretKey;
        return this;
    }

    public CephContainer withCephBucket(String cephBucket) {
        this.cephBucket = cephBucket;
        return this;
    }

    public int getCephPort() {
        return this.getMappedPort(CEPH_RGW_DEFAULT_PORT);
    }

    public URI getCephUrl() throws URISyntaxException {
        return new URI(String.format("http://%s:%s", this.getHost(), this.getCephPort()));
    }

    public String getCephAccessKey() {
        return this.cephAccessKey;
    }

    public String getCephSecretKey() {
        return this.cephSecretKey;
    }

    public String getCephBucket() {
        return this.cephBucket;
    }
}

