/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library;

import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.TagAnnotation;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.configuration.library.reader.ClassLoaderUtils;
import io.github.kbuntrock.configuration.library.reader.JakartaRsReader;
import io.github.kbuntrock.configuration.library.reader.JavaxRsReader;
import io.github.kbuntrock.configuration.library.reader.SpringMvcReader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Library {
    SPRING_MVC(TagAnnotation.SPRING_MVC_REQUEST_MAPPING, TagAnnotation.SPRING_REST_CONTROLLER),
    JAVAX_RS(TagAnnotation.JAVAX_RS_PATH),
    JAKARTA_RS(TagAnnotation.JAKARTA_RS_PATH);

    private static final Map<String, Library> nameMap;
    private final List<TagAnnotation> tagAnnotations = new ArrayList<TagAnnotation>();

    private Library(TagAnnotation ... tagAnnotations) {
        for (TagAnnotation tagAnnotation : tagAnnotations) {
            this.tagAnnotations.add(tagAnnotation);
        }
    }

    public static Library getByName(String name) {
        if ("JAXRS".equals(name.toUpperCase())) {
            return JAVAX_RS;
        }
        Library library = nameMap.get(name.toLowerCase());
        if (library == null) {
            throw new MojoRuntimeException("There is no library corresponding to : " + name);
        }
        return library;
    }

    public List<TagAnnotation> getTagAnnotations() {
        return this.tagAnnotations;
    }

    public Class<? extends Annotation> getByClassName(String className) {
        return ClassLoaderUtils.getByNameRuntimeEx(className);
    }

    public AstractLibraryReader createReader(ApiConfiguration apiConfiguration) {
        switch (this.ordinal()) {
            case 1: {
                return new JavaxRsReader(apiConfiguration);
            }
            case 2: {
                return new JakartaRsReader(apiConfiguration);
            }
            case 0: {
                return new SpringMvcReader(apiConfiguration);
            }
        }
        throw new MojoRuntimeException(this.name() + " library not handled yet.");
    }

    static {
        nameMap = new HashMap<String, Library>();
        nameMap.put(SPRING_MVC.name().toLowerCase(), SPRING_MVC);
        nameMap.put(JAVAX_RS.name().toLowerCase(), JAVAX_RS);
        nameMap.put(JAKARTA_RS.name().toLowerCase(), JAKARTA_RS);
    }
}

