/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import io.github.kbuntrock.configuration.Substitution;
import io.github.kbuntrock.model.OperationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class Operation {
    @Parameter
    private List<Substitution> substitutions = new ArrayList<Substitution>();
    private Map<String, List<Substitution>> substitutionsMap;

    public List<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(List<Substitution> substitutions) {
        this.substitutions = substitutions;
    }

    public Operation() {
    }

    public Operation(Operation operation) {
        for (Substitution substitution : operation.getSubstitutions()) {
            this.substitutions.add(new Substitution(substitution));
        }
    }

    public List<Substitution> getSubstitutionsByType(String type) {
        if (this.substitutionsMap == null) {
            this.substitutionsMap = new HashMap<String, List<Substitution>>();
            for (OperationType opType : OperationType.values()) {
                this.substitutionsMap.put(opType.toString().toLowerCase(), new ArrayList());
            }
            for (Substitution substitution : this.substitutions) {
                if (substitution.getType() == null) {
                    for (List<Substitution> value : this.substitutionsMap.values()) {
                        value.add(substitution);
                    }
                    continue;
                }
                List<Substitution> list = this.substitutionsMap.get(substitution.getType().toLowerCase());
                if (list == null) continue;
                list.add(substitution);
            }
        }
        return this.substitutionsMap.get(type);
    }
}

