/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.model.annotation.OperationAnnotationInfo;
import io.github.kbuntrock.model.annotation.OperationResponse;
import io.github.kbuntrock.reflection.GenericityResolver;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.utils.UnwrappingType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;

public abstract class AstractLibraryReader {
    protected final Log logger = Logger.INSTANCE.getLogger();
    protected final ApiConfiguration apiConfiguration;
    protected final GenericityResolver genericityResolver = new GenericityResolver();
    protected final OpenApiTypeResolver openApiTypeResolver;

    public AstractLibraryReader(ApiConfiguration apiConfiguration, OpenApiTypeResolver openApiTypeResolver) {
        this.apiConfiguration = apiConfiguration;
        this.openApiTypeResolver = openApiTypeResolver;
    }

    protected static String concatenateBasePathAndMethodPath(String basePath, String methodPath, boolean automaticSeparator) {
        String result = basePath + methodPath;
        if (automaticSeparator) {
            if (!(methodPath.isEmpty() || methodPath.startsWith("/") || basePath.endsWith("/"))) {
                result = basePath + "/" + methodPath;
            }
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
        }
        return result;
    }

    protected DataObject readResponseObject(Class clazz, Method method, MergedAnnotations mergedAnnotations) {
        Class<?> returnType = method.getReturnType();
        if (Void.class == returnType || Void.TYPE == returnType) {
            return null;
        }
        DataObject dataObject = new DataObject(this.genericityResolver.resolve(clazz, this.readResponseMethodType(method, mergedAnnotations)), this.openApiTypeResolver);
        dataObject = this.computeFrameworkReturnObject(dataObject);
        this.logger.debug((CharSequence)dataObject.toString());
        return dataObject;
    }

    protected Type readResponseMethodType(Method method, MergedAnnotations mergedAnnotations) {
        return method.getGenericReturnType();
    }

    private DataObject computeFrameworkReturnObject(DataObject dataObject) {
        return this.openApiTypeResolver.unwrapDataObject(dataObject, UnwrappingType.RESPONSE);
    }

    protected boolean isDeprecated(Method originalMethod) {
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        for (Method method : overridenMethods) {
            if (method.getDeclaredAnnotation(Deprecated.class) == null) continue;
            return true;
        }
        return false;
    }

    public abstract List<String> readBasePaths(Class<?> var1, MergedAnnotations var2);

    public abstract void computeAnnotations(Class var1, String var2, Method var3, MergedAnnotations var4, Tag var5) throws MojoFailureException;

    protected abstract List<ParameterObject> readParameters(Class var1, Method var2, MergedAnnotations var3);

    protected abstract List<String> readEndpointPaths(String var1, MergedAnnotation<? extends Annotation> var2);

    protected abstract void setConsumeProduceProperties(Endpoint var1, MergedAnnotations var2) throws MojoFailureException;

    protected abstract int readResponseCode(MergedAnnotations var1);

    protected ParameterObject unwrapParameterObject(ParameterObject parameterObject) {
        DataObject dataObject = this.openApiTypeResolver.unwrapDataObject((DataObject)parameterObject, UnwrappingType.PARAMETER);
        if (parameterObject == dataObject) {
            return parameterObject;
        }
        return new ParameterObject(parameterObject.getName(), dataObject);
    }

    protected void setSwaggerAnnotatedEndpointProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) {
        MergedAnnotation operationAnnotation = mergedAnnotations.get("io.swagger.v3.oas.annotations.Operation");
        if (operationAnnotation.isPresent()) {
            MergedAnnotation[] responseArray;
            String description;
            String summary;
            OperationAnnotationInfo operationInfo = endpoint.getOperationAnnotationInfo();
            String operationId = operationAnnotation.getString("operationId");
            if (!StringUtils.isEmpty((CharSequence)operationId)) {
                operationInfo.setOperationId(operationId);
            }
            if (!StringUtils.isEmpty((CharSequence)(summary = operationAnnotation.getString("summary")))) {
                operationInfo.setSummary(summary);
            }
            if (!StringUtils.isEmpty((CharSequence)(description = operationAnnotation.getString("description")))) {
                operationInfo.setDescription(description);
            }
            for (MergedAnnotation responseAnnotation : responseArray = operationAnnotation.getAnnotationArray("responses", Annotation.class)) {
                Class implementation;
                MergedAnnotation content;
                MergedAnnotation schema;
                Optional<MergedAnnotation> optionalContent;
                MergedAnnotation[] contentArray;
                OperationResponse operationResponse = new OperationResponse();
                String responseCode = responseAnnotation.getString("responseCode");
                if ("default".equals(responseCode)) {
                    operationResponse.setCode(200);
                } else {
                    try {
                        operationResponse.setCode(Integer.parseInt(responseCode));
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn((CharSequence)("Invalid response code '" + responseCode + "' for operation " + operationInfo.getOperationId() + ". Skipping response."));
                        continue;
                    }
                }
                String responseDescription = responseAnnotation.getString("description");
                if (!StringUtils.isEmpty((CharSequence)responseDescription)) {
                    operationResponse.setDescription(responseDescription);
                }
                if ((contentArray = responseAnnotation.getAnnotationArray("content", Annotation.class)).length > 1) {
                    this.logger.warn((CharSequence)("Multiple content annotations found for response code " + responseCode + " and operation " + operationInfo.getOperationId() + ". Only the first one will be used."));
                }
                if ((optionalContent = Arrays.stream(contentArray).findFirst()).isPresent() && (schema = (content = optionalContent.get()).getAnnotation("schema", Annotation.class)).isPresent() && (implementation = schema.getClass("implementation")) != null && !Void.class.equals((Object)implementation) && !Void.TYPE.equals(implementation)) {
                    DataObject responseObject = new DataObject(implementation, this.openApiTypeResolver);
                    operationResponse.setDataObject(responseObject);
                }
                operationInfo.addResponse(operationResponse);
            }
        }
    }

    protected void setSwaggerAnnotatedParameterProperties(Parameter javaParameter, MergedAnnotations mergedAnnotations, ParameterObject parameter) {
    }
}

