/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.Library;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;

public class Analytics {
    private static final String JSON_TEMPLATE = "{\"hash-id\":\"%s\",\"java-version\":\"%s\",\"maven-version\":\"%s\",\"plugin-version\":\"%s\",\"library-id\":%d}";
    private static final String ANALYTICS_URL = "https://api.openapi-maven-plugin.eu/api/v1/notify";
    private boolean sendAnalyticsConfigured;
    private String javaVersion;
    private String mavenVersion;
    private String pluginVersion;
    private int libraryId;
    private String hashId;

    public static Analytics build(boolean analytics, ApiConfiguration apiConfiguration, MavenProject project, PluginDescriptor pluginDescriptor, RuntimeInformation runtimeInformation, boolean testMode) {
        return new Analytics(analytics, apiConfiguration, project, pluginDescriptor, runtimeInformation, testMode);
    }

    private Analytics(boolean analytics, ApiConfiguration apiConfiguration, MavenProject project, PluginDescriptor pluginDescriptor, RuntimeInformation runtimeInformation, boolean testMode) {
        try {
            boolean bl = this.sendAnalyticsConfigured = !testMode && analytics;
            if (this.sendAnalyticsConfigured) {
                this.javaVersion = (String)ObjectUtils.firstNonNull((Object[])new String[]{System.getProperty("java.version"), ""});
                this.mavenVersion = runtimeInformation != null ? runtimeInformation.getMavenVersion() : "";
                this.pluginVersion = pluginDescriptor != null ? pluginDescriptor.getVersion() : "";
                this.libraryId = this.createLibraryId(apiConfiguration.getLibrary());
                this.hashId = this.createHashId(project);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String createHashId(MavenProject project) {
        String id = project.getGroupId() + ":" + project.getArtifactId();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(id.getBytes(StandardCharsets.UTF_8));
            byte[] truncated = Arrays.copyOf(hash, 16);
            return Base64.getEncoder().withoutPadding().encodeToString(truncated);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void send() {
        try {
            if (this.shouldSendAnalytics()) {
                String json = String.format(JSON_TEMPLATE, this.hashId, this.javaVersion, this.mavenVersion, this.pluginVersion, this.libraryId);
                this.postNotificationAsync(ANALYTICS_URL, json).get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean shouldSendAnalytics() {
        return this.sendAnalyticsConfigured && System.currentTimeMillis() % 4L == 0L;
    }

    private CompletableFuture<Void> postNotificationAsync(String url, String json) {
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)new URL(url).openConnection();
                con.setRequestMethod("POST");
                con.setConnectTimeout(500);
                con.setReadTimeout(500);
                con.setDoOutput(true);
                con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                con.setRequestProperty("Accept", "*/*");
                byte[] body = json.getBytes(StandardCharsets.UTF_8);
                try (OutputStream os = con.getOutputStream();){
                    os.write(body);
                }
                con.getResponseCode();
            }
            catch (Exception ignored) {
                Void void_ = null;
                return void_;
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
            return null;
        }, Executors.newFixedThreadPool(1));
    }

    private int createLibraryId(Library library) {
        switch (library) {
            case SPRING_MVC: {
                return 1;
            }
            case JAKARTA_RS: {
                return 2;
            }
            case JAVAX_RS: {
                return 3;
            }
        }
        return 0;
    }
}

