/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.ClassLoaderHelper;
import io.github.kbuntrock.context.ApiContext;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;

public class ApiResourceScanner {
    private final ApiContext context;
    private final ApiConfiguration apiConfiguration;
    private final OpenApiTypeResolver openApiTypeResolver;
    private final Map<String, ClassDocumentation> javadocMap;
    private final List<Pattern> whiteListPatterns = new ArrayList<Pattern>();
    private final List<Pattern> blackListPatterns = new ArrayList<Pattern>();

    public ApiResourceScanner(ApiContext context, Map<String, ClassDocumentation> javadocMap) {
        this.context = context;
        this.apiConfiguration = context.getApiConfiguration();
        this.openApiTypeResolver = context.getOpenApiTypeResolver();
        this.javadocMap = javadocMap;
        if (this.apiConfiguration.getWhiteList() != null) {
            for (String whiteEntry : this.apiConfiguration.getWhiteList()) {
                String regex = whiteEntry.split("#")[0];
                if (whiteEntry.startsWith("#")) continue;
                this.whiteListPatterns.add(Pattern.compile(regex));
            }
        }
        if (this.apiConfiguration.getBlackList() != null) {
            for (String blackEntry : this.apiConfiguration.getBlackList()) {
                String[] regexArray = blackEntry.split("#");
                if (regexArray.length != 1) continue;
                this.blackListPatterns.add(Pattern.compile(regexArray[0]));
            }
        }
    }

    public TagLibrary scanRestControllers() throws MojoFailureException {
        TagLibrary library = new TagLibrary(this.context, this.javadocMap);
        for (String apiLocation : this.apiConfiguration.getLocations()) {
            this.context.getLogger().info((CharSequence)("Scanning : " + apiLocation));
            ClassGraph classGraph = new ClassGraph().enableMethodInfo().enableClassInfo().enableAnnotationInfo().ignoreClassVisibility().ignoreMethodVisibility().ignoreParentClassLoaders().addClassLoader(this.context.getClassLoader());
            if (this.context.getClassLoaderHelper().isClass(apiLocation)) {
                classGraph.acceptClasses(new String[]{apiLocation});
            } else {
                classGraph.acceptPackages(new String[]{apiLocation});
            }
            ScanResult classScanResult = classGraph.scan();
            try {
                String[] annotationNames = this.apiConfiguration.getTagAnnotations().toArray(new String[0]);
                Set restControllerClasses = classScanResult.getClassesWithAnyAnnotation(annotationNames).stream().filter(ApiResourceScanner.onLocation(apiLocation, this.context.getClassLoaderHelper())).map(ClassInfo::loadClass).collect(Collectors.toSet());
                this.context.getLogger().info((CharSequence)("Found " + restControllerClasses.size() + " annotated classes with [ " + String.join((CharSequence)", ", this.apiConfiguration.getTagAnnotations()) + " ]"));
                JavaClassAnalyser javaClassAnalyser = new JavaClassAnalyser(this.context, this.apiConfiguration, classScanResult, this.openApiTypeResolver);
                for (Class restControllerClass : restControllerClasses) {
                    if (!this.validateWhiteList(restControllerClass) || !this.validateBlackList(restControllerClass)) continue;
                    javaClassAnalyser.getTagFromClass(restControllerClass).ifPresent(library::addTag);
                }
                for (String className : this.apiConfiguration.getExtraSchemaClasses()) {
                    try {
                        library.addExtraClass(this.context.getClassLoader().loadClass(className));
                    }
                    catch (ClassNotFoundException e) {
                        throw new MojoRuntimeException("Cannot load extra class " + className, e);
                    }
                }
            }
            finally {
                if (classScanResult == null) continue;
                classScanResult.close();
            }
        }
        library.resolveSchemaReferenceNames();
        return library;
    }

    private static Predicate<ClassInfo> onLocation(String apiLocation, ClassLoaderHelper classLoaderHelper) {
        if (classLoaderHelper.isClass(apiLocation)) {
            return classInfo -> classInfo.getName().equals(apiLocation);
        }
        return classInfo -> classInfo.getPackageName().startsWith(apiLocation);
    }

    private boolean validateWhiteList(Class<?> restControllerClass) {
        if (this.whiteListPatterns.isEmpty()) {
            return true;
        }
        return this.whiteListPatterns.stream().anyMatch(whitePattern -> whitePattern.matcher(restControllerClass.getCanonicalName()).matches());
    }

    private boolean validateBlackList(Class<?> restControllerClass) {
        if (this.blackListPatterns.isEmpty()) {
            return true;
        }
        return this.blackListPatterns.stream().noneMatch(blackPattern -> blackPattern.matcher(restControllerClass.getCanonicalName()).matches());
    }
}

