/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import io.github.kbuntrock.configuration.CommonApiConfiguration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class NullableConfiguration {
    private static final String defaultJakartaNullable = "jakarta.annotation.Nullable";
    private static final String defaultJavaxNullable = "javax.annotation.Nullable";
    private static final String defaultJakartaNotNull = "jakarta.validation.constraints.NotNull";
    private static final String defaultJakartaNotBlank = "jakarta.validation.constraints.NotBlank";
    private static final String defaultJakartaNotEmpty = "jakarta.validation.constraints.NotEmpty";
    private static final String defaultJavaxNotNull = "javax.validation.constraints.NotNull";
    private static final String defaultJavaxNotBlank = "javax.validation.constraints.NotBlank";
    private static final String defaultJavaxNotEmpty = "javax.validation.constraints.NotEmpty";
    private final List<String> nullableAnnotations;
    private final List<String> nonNullAnnotations;
    private final boolean defaultNonNullableFields;

    public NullableConfiguration(CommonApiConfiguration commonApiConfiguration) {
        this.defaultNonNullableFields = commonApiConfiguration.defaultNonNullableFields != null && commonApiConfiguration.defaultNonNullableFields != false;
        this.nullableAnnotations = new ArrayList<String>();
        if (commonApiConfiguration.nullableAnnotation != null) {
            this.nullableAnnotations.addAll(commonApiConfiguration.nullableAnnotation);
        } else {
            this.nullableAnnotations.add(defaultJakartaNullable);
            this.nullableAnnotations.add(defaultJavaxNullable);
        }
        this.nonNullAnnotations = new ArrayList<String>();
        if (commonApiConfiguration.nonNullableAnnotation != null) {
            this.nonNullAnnotations.addAll(commonApiConfiguration.nonNullableAnnotation);
        } else {
            this.nonNullAnnotations.add(defaultJakartaNotNull);
            this.nonNullAnnotations.add(defaultJakartaNotBlank);
            this.nonNullAnnotations.add(defaultJakartaNotEmpty);
            this.nonNullAnnotations.add(defaultJavaxNotNull);
            this.nonNullAnnotations.add(defaultJavaxNotBlank);
            this.nonNullAnnotations.add(defaultJavaxNotEmpty);
        }
    }

    private List<String> getNullableAnnotations() {
        return this.nullableAnnotations;
    }

    private List<String> getNonNullAnnotations() {
        return this.nonNullAnnotations;
    }

    public boolean isDefaultNonNullableFields() {
        return this.defaultNonNullableFields;
    }

    public boolean hasNullableAnnotation(List<Annotation> annotations) {
        return annotations.stream().map(annotation -> annotation.annotationType().getName()).anyMatch(name -> this.getNullableAnnotations().contains(name));
    }

    public boolean hasNonNullAnnotation(List<Annotation> annotations) {
        return annotations.stream().map(annotation -> annotation.annotationType().getName()).anyMatch(name -> this.getNonNullAnnotations().contains(name));
    }
}

