/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library;

import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.TagAnnotation;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.configuration.library.reader.JakartaRsReader;
import io.github.kbuntrock.configuration.library.reader.JavaxRsReader;
import io.github.kbuntrock.configuration.library.reader.SpringMvcReader;
import io.github.kbuntrock.context.ApiContext;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Library {
    SPRING_MVC(TagAnnotation.SPRING_MVC_REQUEST_MAPPING, TagAnnotation.SPRING_REST_CONTROLLER),
    JAVAX_RS(TagAnnotation.JAVAX_RS_PATH),
    JAKARTA_RS(TagAnnotation.JAKARTA_RS_PATH);

    private static final Map<String, Library> nameMap;
    private final List<TagAnnotation> tagAnnotations = new ArrayList<TagAnnotation>();

    private Library(TagAnnotation ... tagAnnotations) {
        for (TagAnnotation tagAnnotation : tagAnnotations) {
            this.tagAnnotations.add(tagAnnotation);
        }
    }

    public static Library getByName(String name) {
        if ("JAXRS".equals(name.toUpperCase())) {
            return JAVAX_RS;
        }
        Library library = nameMap.get(name.toLowerCase());
        if (library == null) {
            throw new MojoRuntimeException("There is no library corresponding to : " + name);
        }
        return library;
    }

    public AstractLibraryReader createReader(ApiContext context, ApiConfiguration apiConfiguration, OpenApiTypeResolver openApiTypeResolver) {
        switch (this) {
            case JAVAX_RS: {
                return new JavaxRsReader(context, apiConfiguration, openApiTypeResolver);
            }
            case JAKARTA_RS: {
                return new JakartaRsReader(context, apiConfiguration, openApiTypeResolver);
            }
            case SPRING_MVC: {
                return new SpringMvcReader(context, apiConfiguration, openApiTypeResolver);
            }
        }
        throw new MojoRuntimeException(this.name() + " library not handled yet.");
    }

    static {
        nameMap = new HashMap<String, Library>();
        nameMap.put(SPRING_MVC.name().toLowerCase(), SPRING_MVC);
        nameMap.put(JAVAX_RS.name().toLowerCase(), JAVAX_RS);
        nameMap.put(JAKARTA_RS.name().toLowerCase(), JAKARTA_RS);
    }
}

