/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.MojoRuntimeException;
import java.util.HashMap;
import java.util.Map;

public final class ClassLoaderHelper {
    private final ClassLoader classLoader;
    private final Map<String, Class> map = new HashMap<String, Class>();

    public ClassLoaderHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class getByName(String canonicalName) throws ClassNotFoundException {
        Class clazz = this.map.get(canonicalName);
        if (clazz == null) {
            this.map.put(canonicalName, Class.forName(canonicalName, true, this.classLoader));
            clazz = this.map.get(canonicalName);
        }
        return clazz;
    }

    public Class getByNameRuntimeEx(String canonicalName) {
        try {
            return this.getByName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new MojoRuntimeException(canonicalName + " cannot be loaded. Please check if the correct dependencies are in your project classpath.", e);
        }
    }

    public boolean isClass(String canonicalName) {
        try {
            Class clazz = this.getByName(canonicalName);
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

