/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.MarkdownComment;
import com.github.javaparser.ast.comments.TraditionalJavadocComment;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.configuration.JavadocConfiguration;
import io.github.kbuntrock.context.ProjectContext;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.javadoc.CommentType;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JavadocParser {
    private static final String LOG_PREFIX = JavadocParser.class.getSimpleName() + " - ";
    private final ProjectContext context;
    private final JavaParser javaParser;
    private final Map<String, ClassDocumentation> javadocMap = new HashMap<String, ClassDocumentation>();
    private final List<File> filesToScan;
    private final JavadocVisitor visitor = new JavadocVisitor();
    private final boolean debugScan;

    public JavadocParser(ProjectContext context, List<File> filesToScan, JavadocConfiguration javadocConfiguration) {
        this.context = context;
        this.filesToScan = filesToScan;
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE);
        Charset charset = StandardCharsets.UTF_8;
        if (Charset.isSupported(javadocConfiguration.getEncoding())) {
            charset = Charset.forName(javadocConfiguration.getEncoding());
        } else {
            context.getLogger().warn((CharSequence)("Encoding " + javadocConfiguration.getEncoding() + " is not supported. UTF-8 will be used instead."));
            context.getLogger().warn((CharSequence)("Supported encoding on this JVM are : " + String.join((CharSequence)", ", Charset.availableCharsets().keySet())));
        }
        parserConfiguration.setCharacterEncoding(charset);
        this.debugScan = javadocConfiguration.isDebugScan();
        this.javaParser = new JavaParser(parserConfiguration);
    }

    public void scan() {
        for (File file : this.filesToScan) {
            if (!file.exists()) {
                this.context.getLogger().warn((CharSequence)(LOG_PREFIX + "Directory " + file.getAbsolutePath() + " does not exist."));
                continue;
            }
            if (!file.isDirectory()) {
                this.context.getLogger().warn((CharSequence)(LOG_PREFIX + "File " + file.getAbsolutePath() + " is not a directory."));
                continue;
            }
            try {
                this.context.getLogger().info((CharSequence)(LOG_PREFIX + "Scanning directory : " + file.getAbsolutePath()));
                this.exploreDirectory(file);
            }
            catch (FileNotFoundException e) {
                this.context.getLogger().error((CharSequence)(LOG_PREFIX + "Cannot read file " + file.getAbsolutePath()));
                throw new RuntimeException("Cannot read file", e);
            }
        }
        this.printDebug();
    }

    private void printDebug() {
        if (this.debugScan) {
            this.context.getLogger().debug((CharSequence)"-------- PRINT JAVADOC SCAN RESULTS ----------");
            for (ClassDocumentation classDocumentation : this.javadocMap.values()) {
                this.context.getLogger().debug((CharSequence)("Class documentation for : " + classDocumentation.getCompleteName()));
                this.context.getLogger().debug((CharSequence)("Summary : " + classDocumentation.getSummary()));
                this.context.getLogger().debug((CharSequence)("Description : " + classDocumentation.getDescription()));
                if (classDocumentation.getMethodsJavadocByIdentifier().isEmpty()) continue;
                for (Map.Entry<String, JavadocWrapper> entry : classDocumentation.getMethodsJavadocByIdentifier().entrySet()) {
                    this.context.getLogger().debug((CharSequence)("Method doc for : " + entry.getKey()));
                    this.context.getLogger().debug((CharSequence)("Summary : " + entry.getValue().getSummary()));
                    this.context.getLogger().debug((CharSequence)("Description : " + entry.getValue().getDescription()));
                    entry.getValue().printParameters(this.context.getLogger());
                    entry.getValue().printReturn(this.context.getLogger());
                }
            }
        }
    }

    private void exploreDirectory(File directory) throws FileNotFoundException {
        for (File child : directory.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".java")) {
                this.exploreJavaFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.exploreDirectory(child);
        }
    }

    private void exploreJavaFile(File javaFile) throws FileNotFoundException {
        try {
            ParseResult parseResult = this.javaParser.parse(javaFile);
            if (!parseResult.isSuccessful()) {
                throw new ParseProblemException(parseResult.getProblems());
            }
            CompilationUnit compilationUnit = (CompilationUnit)parseResult.getResult().get();
            this.visitor.visit(compilationUnit, null);
        }
        catch (ParseProblemException ex) {
            this.context.getLogger().warn((CharSequence)("Error while parsing javadoc of file " + javaFile.getName() + " -> " + ex.getMessage()));
        }
    }

    private Optional<ClassDocumentation> findClassDocumentationForNode(Node commentedNode) {
        ClassOrInterfaceDeclaration classDeclaration = null;
        if (commentedNode instanceof ClassOrInterfaceDeclaration) {
            classDeclaration = (ClassOrInterfaceDeclaration)commentedNode;
        } else if (commentedNode.hasParentNode() && commentedNode.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            classDeclaration = (ClassOrInterfaceDeclaration)commentedNode.getParentNode().get();
        }
        if (classDeclaration != null && classDeclaration.getFullyQualifiedName().isPresent()) {
            ClassOrInterfaceDeclaration dec = classDeclaration;
            return Optional.of(this.javadocMap.computeIfAbsent((String)dec.getFullyQualifiedName().get(), key -> new ClassDocumentation((String)dec.getFullyQualifiedName().get(), dec.getName().asString())));
        }
        if (commentedNode instanceof RecordDeclaration && ((RecordDeclaration)commentedNode).getFullyQualifiedName().isPresent()) {
            String fullName = (String)((RecordDeclaration)commentedNode).getFullyQualifiedName().get();
            RecordDeclaration dec = (RecordDeclaration)commentedNode;
            return Optional.of(this.javadocMap.computeIfAbsent(fullName, key -> new ClassDocumentation(fullName, dec.getName().asString())));
        }
        EnumDeclaration enumDeclaration = null;
        if (commentedNode instanceof EnumDeclaration) {
            enumDeclaration = (EnumDeclaration)commentedNode;
        } else if (commentedNode.hasParentNode() && commentedNode.getParentNode().get() instanceof EnumDeclaration) {
            enumDeclaration = (EnumDeclaration)commentedNode.getParentNode().get();
        }
        if (enumDeclaration != null && enumDeclaration.getFullyQualifiedName().isPresent()) {
            EnumDeclaration dec = enumDeclaration;
            return Optional.of(this.javadocMap.computeIfAbsent((String)dec.getFullyQualifiedName().get(), key -> new ClassDocumentation((String)dec.getFullyQualifiedName().get(), dec.getName().asString())));
        }
        return Optional.empty();
    }

    public Map<String, ClassDocumentation> getJavadocMap() {
        return this.javadocMap;
    }

    private class JavadocVisitor
    extends VoidVisitorAdapter {
        private JavadocVisitor() {
        }

        public void visit(TraditionalJavadocComment comment, Object arg) {
            super.visit(comment, arg);
            this.visitInternal((JavadocComment)comment, arg);
        }

        public void visit(MarkdownComment comment, Object arg) {
            super.visit(comment, arg);
            this.visitInternal((JavadocComment)comment, arg);
        }

        private void visitInternal(JavadocComment comment, Object arg) {
            Optional classDocumentation;
            CommentType type = CommentType.fromNode((Node)comment.getCommentedNode().get());
            if (CommentType.OTHER != type && (classDocumentation = JavadocParser.this.findClassDocumentationForNode((Node)comment.getCommentedNode().get())).isPresent()) {
                Javadoc javadoc = comment.parse();
                switch (type) {
                    case CLASS: {
                        ((ClassDocumentation)classDocumentation.get()).setJavadoc(javadoc);
                        break;
                    }
                    case FIELD: {
                        ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put(((FieldDeclaration)comment.getCommentedNode().get()).getVariable(0).getNameAsString(), new JavadocWrapper(javadoc));
                        break;
                    }
                    case RECORD: {
                        ((ClassDocumentation)classDocumentation.get()).setJavadoc(javadoc);
                        for (JavadocBlockTag parameter : javadoc.getBlockTags()) {
                            if (parameter.getContent().isEmpty() || !parameter.getName().isPresent()) continue;
                            ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put((String)parameter.getName().get(), new JavadocWrapper(new Javadoc(parameter.getContent())));
                        }
                        break;
                    }
                    case ENUM_VALUE: {
                        ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put(((EnumConstantDeclaration)comment.getCommentedNode().get()).getNameAsString(), new JavadocWrapper(javadoc));
                        break;
                    }
                    case METHOD: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)comment.getCommentedNode().get();
                        JavadocWrapper wrapper = new JavadocWrapper(javadoc);
                        ((ClassDocumentation)classDocumentation.get()).getMethodsJavadocByIdentifier().put(methodDeclaration.getSignature().toString(), wrapper);
                    }
                }
            }
        }
    }
}

