/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import java.util.HashSet;
import java.util.Locale;

public enum JavadocTag {
    SUMMARY,
    AUTHOR,
    CODE,
    LINK,
    SEE;

    private static final HashSet<JavadocTag> formattingTags;

    public static JavadocTag fromString(String tagName) {
        return JavadocTag.valueOf(tagName.toUpperCase(Locale.ROOT));
    }

    public static boolean isFormattingTag(String tagName) {
        try {
            JavadocTag tag = JavadocTag.fromString(tagName);
            return JavadocTag.isFormattingTag(tag);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isFormattingTag(JavadocTag tag) {
        return formattingTags.contains((Object)tag);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        formattingTags = new HashSet();
        formattingTags.add(CODE);
        formattingTags.add(LINK);
        formattingTags.add(SEE);
    }
}

