/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.github.kbuntrock.javadoc.JavadocElementParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;

public class JavadocWrapper {
    private final Javadoc javadoc;
    private Map<JavadocBlockTag.Type, List<JavadocBlockTag>> blockTagsByType;
    private Map<String, JavadocBlockTag> paramBlockTagsByName;
    private boolean inheritTagFound = false;
    private boolean sortDone = false;

    public JavadocWrapper(Javadoc javadoc) {
        this.javadoc = javadoc;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public void sortTags() {
        if (this.sortDone) {
            return;
        }
        this.sortDone = true;
        this.blockTagsByType = new HashMap<JavadocBlockTag.Type, List<JavadocBlockTag>>();
        this.paramBlockTagsByName = new HashMap<String, JavadocBlockTag>();
        this.inheritTagFound = this.javadoc.getDescription().getElements().stream().anyMatch(e -> e instanceof JavadocInlineTag && JavadocInlineTag.Type.INHERIT_DOC == ((JavadocInlineTag)e).getType());
        for (JavadocBlockTag blockTag : this.javadoc.getBlockTags()) {
            List list = this.blockTagsByType.computeIfAbsent(blockTag.getType(), k -> new ArrayList());
            list.add(blockTag);
            if (JavadocBlockTag.Type.PARAM != blockTag.getType() || !blockTag.getName().isPresent()) continue;
            this.paramBlockTagsByName.put((String)blockTag.getName().get(), blockTag);
        }
    }

    public Optional<JavadocBlockTag> getParamBlockTagByName(String parameterName) {
        return Optional.ofNullable(this.paramBlockTagsByName.get(parameterName));
    }

    public Optional<JavadocBlockTag> getReturnBlockTag() {
        List<JavadocBlockTag> list = this.blockTagsByType.get(JavadocBlockTag.Type.RETURN);
        if (list != null && !list.isEmpty()) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Optional<String> getSummary() {
        return JavadocElementParser.getSummary(this.javadoc.getDescription());
    }

    public Optional<String> getDescription() {
        return JavadocElementParser.getDescription(this.javadoc.getDescription());
    }

    public boolean isInheritTagFound() {
        return this.inheritTagFound;
    }

    public void printParameters(Log logger) {
        if (this.paramBlockTagsByName != null && !this.paramBlockTagsByName.isEmpty()) {
            logger.debug((CharSequence)"Parameters : ");
            for (Map.Entry<String, JavadocBlockTag> entry : this.paramBlockTagsByName.entrySet()) {
                logger.debug((CharSequence)(entry.getKey() + " : " + entry.getValue().getContent().toText()));
            }
        }
    }

    public void printReturn(Log logger) {
        if (this.blockTagsByType != null) {
            Optional<JavadocBlockTag> returnTag = this.getReturnBlockTag();
            returnTag.ifPresent(javadocBlockTag -> logger.debug((CharSequence)("Return : " + javadocBlockTag.getContent().toText())));
        }
    }
}

