/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ReflectionsUtils {
    private ReflectionsUtils() {
    }

    public static List<Field> getAllNonStaticFields(List<Field> fields, Class<?> type) {
        if (type.getSuperclass() != null) {
            ReflectionsUtils.getAllNonStaticFields(fields, type.getSuperclass());
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()).stream().filter(x -> !Modifier.isStatic(x.getModifiers())).collect(Collectors.toList()));
        return fields;
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        if (type.getSuperclass() != null) {
            ReflectionsUtils.getAllFields(fields, type.getSuperclass());
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        return fields;
    }

    public static String getClassNameFromType(Type type) {
        return type.toString().replaceAll("class ", "").replaceAll("interface ", "");
    }
}

