/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.yaml.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.utils.OpenApiTypeResolver;
import io.github.kbuntrock.yaml.model.ContentType;
import io.github.kbuntrock.yaml.model.Property;
import io.github.kbuntrock.yaml.model.Schema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Content {
    @JsonIgnore
    private List<Schema> schemas;
    @JsonIgnore
    private Map<String, ContentType> encoding;

    public static Content fromMultipartBodies(List<ParameterObject> parameterObjects, TagLibrary tagLibrary) {
        Content content = new Content();
        Schema schema = new Schema(tagLibrary.getContext(), tagLibrary.getApiConfiguration());
        content.schemas = new ArrayList<Schema>();
        content.schemas.add(schema);
        schema.setType(OpenApiTypeResolver.OBJECT_TYPE);
        schema.setRequired(parameterObjects.stream().filter(ParameterObject::isRequired).map(ParameterObject::getName).collect(Collectors.toList()));
        schema.properties = parameterObjects.stream().collect(Collectors.toMap(ParameterObject::getName, po -> new Property(Content.fromDataObject(po, tagLibrary).getSingleSchema())));
        return content;
    }

    public static Content fromMultipartFormData(List<ParameterObject> bodyParts, JavadocWrapper methodJavadoc, TagLibrary tagLibrary) {
        Content content = new Content();
        Schema schema = new Schema(tagLibrary.getContext(), tagLibrary.getApiConfiguration());
        content.schemas = new ArrayList<Schema>();
        content.schemas.add(schema);
        schema.setType(OpenApiTypeResolver.OBJECT_TYPE);
        schema.setRequired(bodyParts.stream().filter(ParameterObject::isRequired).map(ParameterObject::getName).collect(Collectors.toList()));
        content.encoding = new LinkedHashMap<String, ContentType>();
        schema.properties = new LinkedHashMap<String, Property>();
        for (ParameterObject bodyPart : bodyParts) {
            String description;
            Optional<JavadocBlockTag> parameterDoc;
            Property property = new Property(Content.fromDataObject(bodyPart, tagLibrary).getSingleSchema());
            schema.properties.put(bodyPart.getName(), property);
            if (bodyPart.getOpenApiResolvedType().getDefaultEncoding() != null) {
                content.encoding.put(bodyPart.getName(), new ContentType(bodyPart.getOpenApiResolvedType().getDefaultEncoding()));
            }
            if (methodJavadoc == null || !(parameterDoc = methodJavadoc.getParamBlockTagByName(bodyPart.getJavadocFieldName())).isPresent() || (description = parameterDoc.get().getContent().toText()).isEmpty()) continue;
            property.setDescription(parameterDoc.get().getContent().toText());
        }
        return content;
    }

    public static Content fromDataObject(DataObject dataObject, TagLibrary tagLibrary) {
        if (dataObject == null) {
            return null;
        }
        HashSet<String> exploredSignatures = new HashSet<String>();
        Content content = new Content();
        content.schemas = new ArrayList<Schema>();
        content.schemas.add(new Schema(dataObject, exploredSignatures, tagLibrary));
        return content;
    }

    @JsonIgnore
    public Schema getSingleSchema() {
        return this.schemas == null ? null : this.schemas.get(0);
    }

    @JsonIgnore
    public List<Schema> getSchemaList() {
        return this.schemas;
    }

    @JsonIgnore
    public Map<String, ContentType> getEncoding() {
        return this.encoding;
    }

    @JsonAnyGetter
    public Map<String, Object> getJsonObject() {
        LinkedHashMap<String, Object> contentMap = new LinkedHashMap<String, Object>();
        if (this.schemas != null) {
            if (this.schemas.size() == 1) {
                contentMap.put("schema", this.schemas.get(0));
            } else {
                LinkedHashMap<String, List<Schema>> schemaMap = new LinkedHashMap<String, List<Schema>>();
                schemaMap.put("anyOf", this.schemas);
                contentMap.put("schema", schemaMap);
            }
        }
        if (this.encoding != null && !this.encoding.isEmpty()) {
            contentMap.put("encoding", this.encoding);
        }
        return contentMap;
    }
}

