/*
 * Decompiled with CFR 0.152.
 */
package io.github.mweirauch.micrometer.jvm.extras;

import io.github.mweirauch.micrometer.jvm.extras.procfs.ProcfsSmaps;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Locale;
import java.util.Objects;

public class ProcessMemoryMetrics
implements MeterBinder {
    private final ProcfsSmaps smaps;

    public ProcessMemoryMetrics() {
        this.smaps = new ProcfsSmaps();
    }

    ProcessMemoryMetrics(ProcfsSmaps smaps) {
        this.smaps = Objects.requireNonNull(smaps);
    }

    public void bindTo(MeterRegistry registry) {
        for (ProcfsSmaps.KEY key : ProcfsSmaps.KEY.values()) {
            String name = "process.memory." + key.name().toLowerCase(Locale.ENGLISH);
            Gauge.builder((String)name, (Object)this.smaps, smapsRef -> this.value(key)).baseUnit("bytes").register(registry);
        }
    }

    private Double value(ProcfsSmaps.KEY key) {
        return this.smaps.get(key);
    }
}

