/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.markup.builder.asciidoc;

import io.github.robwin.markup.builder.AbstractMarkupDocBuilder;
import io.github.robwin.markup.builder.MarkupDocBuilder;
import io.github.robwin.markup.builder.asciidoc.AsciiDoc;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public class AsciiDocBuilder
extends AbstractMarkupDocBuilder {
    @Override
    public MarkupDocBuilder documentTitle(String title) {
        this.documentTitle(AsciiDoc.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder documentTitleWithAttributes(String title) {
        this.documentTitle(AsciiDoc.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel1(String title) {
        this.sectionTitleLevel1(AsciiDoc.SECTION_TITLE_LEVEL1, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel2(String title) {
        this.sectionTitleLevel2(AsciiDoc.SECTION_TITLE_LEVEL2, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel3(String title) {
        this.sectionTitleLevel3(AsciiDoc.SECTION_TITLE_LEVEL3, title);
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text) {
        this.paragraph(AsciiDoc.HARDBREAKS, text);
        return this;
    }

    @Override
    public MarkupDocBuilder listing(String text) {
        this.listing(AsciiDoc.LISTING, text);
        return this;
    }

    @Override
    public MarkupDocBuilder boldTextLine(String text) {
        this.boldTextLine(AsciiDoc.BOLD, text);
        return this;
    }

    @Override
    public MarkupDocBuilder italicTextLine(String text) {
        this.italicTextLine(AsciiDoc.ITALIC, text);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedList(List<String> list) {
        this.unorderedList(AsciiDoc.LIST_ENTRY, list);
        return this;
    }

    @Override
    public MarkupDocBuilder source(String text, String language) {
        this.documentBuilder.append(String.format("[source,%s]", language)).append(this.newLine);
        this.listing(AsciiDoc.LISTING, text);
        return this;
    }

    @Override
    public MarkupDocBuilder tableWithHeaderRow(List<String> rowsInPSV) {
        this.documentBuilder.append("[options=\"header\"]").append(this.newLine);
        this.documentBuilder.append(AsciiDoc.TABLE).append(this.newLine);
        for (String row : rowsInPSV) {
            this.documentBuilder.append(AsciiDoc.TABLE_COLUMN_DELIMITER).append(row).append(this.newLine);
        }
        this.documentBuilder.append(AsciiDoc.TABLE).append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder crossReference(String text) {
        this.documentBuilder.append(AsciiDoc.CROSS_REFERENCE_START).append(text).append(AsciiDoc.CROSS_REFERENCE_END);
        return this;
    }

    @Override
    public void writeToFile(String directory, String fileName, Charset charset) throws IOException {
        String fileNameWithExtension = fileName + ".adoc";
        super.writeToFile(directory, fileNameWithExtension, charset);
    }
}

