/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Endpoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public abstract class EndpointDeserializer<T extends Endpoint>
extends StdScalarDeserializer<T> {
    public EndpointDeserializer(Class<T> vc) {
        super(vc);
    }

    protected void deserialize(T endpoint, JsonParser jsonParser, JsonNode node, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode inheritNode;
        JsonNode tenantsNode;
        JsonNode weightNode = node.get("weight");
        if (weightNode != null) {
            int weight = weightNode.asInt(Endpoint.DEFAULT_WEIGHT);
            endpoint.setWeight(weight);
        } else {
            endpoint.setWeight(Endpoint.DEFAULT_WEIGHT);
        }
        JsonNode backupNode = node.get("backup");
        if (backupNode != null) {
            boolean backup = backupNode.asBoolean(false);
            endpoint.setBackup(backup);
        } else {
            endpoint.setBackup(false);
        }
        JsonNode singleTenantNode = node.get("tenant");
        if (singleTenantNode != null) {
            String tenant = singleTenantNode.asText();
            endpoint.setTenants(Collections.singletonList(tenant));
        }
        if ((tenantsNode = node.get("tenants")) != null && tenantsNode.isArray()) {
            ArrayList tenants = new ArrayList(tenantsNode.size());
            tenantsNode.elements().forEachRemaining(tenantNode -> tenants.add(tenantNode.asText()));
            endpoint.setTenants(tenants);
        }
        if ((inheritNode = node.get("inherit")) != null) {
            endpoint.setInherit(Boolean.valueOf(inheritNode.asBoolean()));
        }
    }
}

