/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.HttpProxy;
import io.gravitee.definition.model.HttpProxyType;
import java.io.IOException;

public class HttpProxyDeserializer
extends StdScalarDeserializer<HttpProxy> {
    public HttpProxyDeserializer(Class<HttpProxy> vc) {
        super(vc);
    }

    public HttpProxy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpProxy httpProxy = new HttpProxy();
        JsonNode enabledNode = node.get("enabled");
        if (enabledNode != null) {
            boolean enabled = enabledNode.asBoolean(false);
            httpProxy.setEnabled(enabled);
        }
        httpProxy.setHost(this.readStringValue(node, "host"));
        String sPort = this.readStringValue(node, "port");
        if (sPort != null) {
            httpProxy.setPort(Integer.parseInt(sPort));
        }
        httpProxy.setPassword(this.readStringValue(node, "password"));
        httpProxy.setUsername(this.readStringValue(node, "username"));
        JsonNode typeNode = node.get("type");
        if (typeNode != null) {
            httpProxy.setType(HttpProxyType.valueOf((String)typeNode.asText().toUpperCase()));
        }
        return httpProxy;
    }

    private String readStringValue(JsonNode rootNode, String fieldName) {
        JsonNode fieldNode = rootNode.get(fieldName);
        if (fieldNode != null) {
            return fieldNode.asText();
        }
        return null;
    }
}

