/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.Cors;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Failover;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ProxyDeserializer
extends StdScalarDeserializer<Proxy> {
    public ProxyDeserializer(Class<Proxy> vc) {
        super(vc);
    }

    public Proxy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode corsNode;
        JsonNode loggingNode;
        JsonNode loggingModeNode;
        JsonNode failoverNode;
        JsonNode preserveHostNode;
        JsonNode stripContextNode;
        JsonNode virtualHostsNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Proxy proxy = new Proxy();
        JsonNode contextPathNode = node.get("context_path");
        if (contextPathNode != null) {
            String sContextPath = this.formatContextPath(contextPathNode.asText());
            VirtualHost defaultHost = new VirtualHost();
            defaultHost.setPath(sContextPath);
            proxy.setVirtualHosts(Collections.singletonList(defaultHost));
        }
        if ((virtualHostsNode = node.get("virtual_hosts")) != null && virtualHostsNode.isArray()) {
            ArrayList virtualHosts = new ArrayList();
            virtualHostsNode.elements().forEachRemaining(node1 -> {
                try {
                    virtualHosts.add(node1.traverse(jp.getCodec()).readValueAs(VirtualHost.class));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            proxy.setVirtualHosts(virtualHosts);
        }
        if (proxy.getVirtualHosts() == null || proxy.getVirtualHosts().isEmpty()) {
            ctxt.reportBadDefinition(Proxy.class, "[api] API must define at least a single context_path or one or multiple virtual_hosts");
        }
        JsonNode nodeEndpoints = node.get("endpoints");
        JsonNode nodeGroups = node.get("groups");
        if (nodeEndpoints != null && nodeEndpoints.isArray()) {
            this.createDefaultEndpointGroup(node, jp.getCodec(), proxy);
        } else if (nodeGroups != null && nodeGroups.isArray()) {
            this.createEndpointGroups(node, jp.getCodec(), proxy, ctxt);
        }
        if (proxy.getGroups() != null && !proxy.getGroups().isEmpty()) {
            Set endpointNames = proxy.getGroups().stream().map(EndpointGroup::getName).collect(Collectors.toSet());
            for (EndpointGroup group : proxy.getGroups()) {
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    if (endpointNames.contains(endpoint.getName())) {
                        ctxt.reportBadDefinition(Proxy.class, "[api] API endpoint names and group names must be unique");
                    }
                    endpointNames.add(endpoint.getName());
                }
            }
        }
        if ((stripContextNode = node.get("strip_context_path")) != null) {
            proxy.setStripContextPath(stripContextNode.asBoolean(false));
        }
        if ((preserveHostNode = node.get("preserve_host")) != null) {
            proxy.setPreserveHost(preserveHostNode.asBoolean(false));
        }
        if ((failoverNode = node.get("failover")) != null) {
            Failover failover = (Failover)failoverNode.traverse(jp.getCodec()).readValueAs(Failover.class);
            proxy.setFailover(failover);
        }
        if ((loggingModeNode = node.get("loggingMode")) != null) {
            Logging logging = new Logging();
            logging.setMode(LoggingMode.valueOf((String)loggingModeNode.asText().toUpperCase()));
            proxy.setLogging(logging);
        }
        if ((loggingNode = node.get("logging")) != null) {
            Logging logging = (Logging)loggingNode.traverse(jp.getCodec()).readValueAs(Logging.class);
            proxy.setLogging(logging);
        }
        if ((corsNode = node.get("cors")) != null) {
            Cors cors = (Cors)corsNode.traverse(jp.getCodec()).readValueAs(Cors.class);
            proxy.setCors(cors);
        }
        return proxy;
    }

    private void createDefaultEndpointGroup(JsonNode node, ObjectCodec codec, Proxy proxy) throws IOException {
        EndpointGroup group = (EndpointGroup)node.traverse(codec).readValueAs(EndpointGroup.class);
        group.setName("default-group");
        proxy.setGroups(Collections.singleton(group));
    }

    private void createEndpointGroups(JsonNode node, ObjectCodec codec, Proxy proxy, DeserializationContext ctxt) throws IOException {
        JsonNode nodeGroups = node.get("groups");
        LinkedHashSet<EndpointGroup> groups = new LinkedHashSet<EndpointGroup>(nodeGroups.size());
        for (JsonNode jsonNode : nodeGroups) {
            EndpointGroup group = (EndpointGroup)jsonNode.traverse(codec).readValueAs(EndpointGroup.class);
            boolean added = groups.add(group);
            if (added) continue;
            ctxt.reportBadDefinition(Proxy.class, "[api] API must have single endpoint group names");
        }
        proxy.setGroups(groups);
    }

    private String formatContextPath(String contextPath) {
        String[] parts = contextPath.split("/");
        StringBuilder finalPath = new StringBuilder("/");
        for (String part : parts) {
            if (part.isEmpty()) continue;
            finalPath.append(part).append('/');
        }
        return finalPath.deleteCharAt(finalPath.length() - 1).toString();
    }
}

