/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.VirtualHost;
import java.io.IOException;

public class VirtualHostDeserializer
extends StdScalarDeserializer<VirtualHost> {
    public VirtualHostDeserializer(Class<VirtualHost> vc) {
        super(vc);
    }

    public VirtualHost deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode pathNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        VirtualHost vhost = new VirtualHost();
        JsonNode hostNode = node.get("host");
        if (hostNode != null) {
            vhost.setHost(hostNode.asText());
        }
        if ((pathNode = node.get("path")) != null) {
            vhost.setPath(this.formatContextPath(pathNode.asText()));
        } else {
            vhost.setPath("/");
        }
        vhost.setOverrideEntrypoint(node.path("override_entrypoint").asBoolean(false));
        return vhost;
    }

    private String formatContextPath(String contextPath) {
        String[] parts = contextPath.split("/");
        StringBuilder finalPath = new StringBuilder("/");
        for (String part : parts) {
            if (part.isEmpty()) continue;
            finalPath.append(part).append('/');
        }
        return finalPath.deleteCharAt(finalPath.length() - 1).toString();
    }
}

