/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.deser.endpoint;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.definition.jackson.datatype.api.deser.EndpointDeserializer;
import io.gravitee.definition.model.HttpClientOptions;
import io.gravitee.definition.model.HttpClientSslOptions;
import io.gravitee.definition.model.HttpProxy;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.definition.model.services.healthcheck.EndpointHealthCheckService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class HttpEndpointDeserializer
extends EndpointDeserializer<HttpEndpoint> {
    public HttpEndpointDeserializer(Class<HttpEndpoint> vc) {
        super(vc);
    }

    public HttpEndpoint deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode nameNode = node.get("name");
        if (nameNode == null) {
            throw ctxt.mappingException("Endpoint name is required");
        }
        String name = nameNode.asText();
        JsonNode targetNode = node.get("target");
        if (targetNode == null) {
            throw ctxt.mappingException("Endpoint target is required");
        }
        String target = targetNode.asText();
        HttpEndpoint endpoint = new HttpEndpoint(name, target);
        this.deserialize(endpoint, jp, node, ctxt);
        JsonNode healthcheckNode = node.get("healthcheck");
        if (healthcheckNode != null && healthcheckNode.isObject()) {
            EndpointHealthCheckService healthCheckService = (EndpointHealthCheckService)healthcheckNode.traverse(jp.getCodec()).readValueAs(EndpointHealthCheckService.class);
            endpoint.setHealthCheck(healthCheckService);
        }
        if (endpoint.getInherit() == null || endpoint.getInherit().equals(Boolean.FALSE)) {
            JsonNode headersNode;
            Map<String, String> headers;
            String hostHeader;
            JsonNode hostHeaderNode;
            JsonNode httpClientOptionsNode;
            JsonNode httpProxyNode = node.get("proxy");
            if (httpProxyNode != null) {
                HttpProxy httpProxy = (HttpProxy)httpProxyNode.traverse(jp.getCodec()).readValueAs(HttpProxy.class);
                endpoint.setHttpProxy(httpProxy);
            }
            if ((httpClientOptionsNode = node.get("http")) != null) {
                HttpClientOptions httpClientOptions = (HttpClientOptions)httpClientOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientOptions.class);
                endpoint.setHttpClientOptions(httpClientOptions);
            } else {
                endpoint.setHttpClientOptions(new HttpClientOptions());
            }
            JsonNode httpClientSslOptionsNode = node.get("ssl");
            if (httpClientSslOptionsNode != null) {
                HttpClientSslOptions httpClientSslOptions = (HttpClientSslOptions)httpClientSslOptionsNode.traverse(jp.getCodec()).readValueAs(HttpClientSslOptions.class);
                endpoint.setHttpClientSslOptions(httpClientSslOptions);
            }
            if ((hostHeaderNode = node.get("hostHeader")) != null && !(hostHeader = hostHeaderNode.asText()).trim().isEmpty()) {
                headers = new HashMap<String, String>();
                headers.put("Host", hostHeader);
                endpoint.setHeaders(headers);
            }
            if ((headersNode = node.get("headers")) != null && !headersNode.isEmpty(null) && (headers = (Map)headersNode.traverse(jp.getCodec()).readValueAs((TypeReference)new TypeReference<HashMap<String, String>>(){})) != null && !headers.isEmpty()) {
                if (endpoint.getHeaders() == null) {
                    endpoint.setHeaders(headers);
                } else {
                    headers.forEach(endpoint.getHeaders()::putIfAbsent);
                }
            }
        }
        return endpoint;
    }
}

