/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.api.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.gravitee.definition.model.EndpointGroup;
import java.io.IOException;
import java.util.Set;

public class EndpointGroupSerializer
extends StdScalarSerializer<EndpointGroup> {
    public EndpointGroupSerializer(Class<EndpointGroup> vc) {
        super(vc);
    }

    public void serialize(EndpointGroup group, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("name", group.getName());
        Set endpoints = group.getEndpoints();
        if (endpoints != null) {
            jgen.writeArrayFieldStart("endpoints");
            endpoints.forEach(endpoint -> {
                try {
                    jgen.writeObject(endpoint);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            jgen.writeEndArray();
        }
        if (group.getLoadBalancer() != null) {
            jgen.writeObjectField("load_balancing", (Object)group.getLoadBalancer());
        }
        if (group.getServices() != null && !group.getServices().isEmpty()) {
            jgen.writeObjectField("services", (Object)group.getServices());
        }
        if (group.getHttpProxy() != null) {
            jgen.writeObjectField("proxy", (Object)group.getHttpProxy());
        }
        if (group.getHttpClientOptions() != null) {
            jgen.writeObjectField("http", (Object)group.getHttpClientOptions());
        }
        if (group.getHttpClientSslOptions() != null) {
            jgen.writeObjectField("ssl", (Object)group.getHttpClientSslOptions());
        }
        if (group.getHeaders() != null && !group.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", (Object)group.getHeaders());
        }
        jgen.writeEndObject();
    }
}

