/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.core.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.gravitee.definition.jackson.datatype.services.core.ser.ServiceSerializer;
import io.gravitee.definition.model.services.schedule.ScheduledService;
import io.gravitee.definition.model.services.schedule.Trigger;
import java.io.IOException;

public abstract class ScheduledServiceSerializer<T extends ScheduledService>
extends ServiceSerializer<T> {
    protected ScheduledServiceSerializer(Class<T> t) {
        super(t);
    }

    @Override
    protected void doSerialize(T service, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        super.doSerialize(service, jgen, serializerProvider);
        Trigger trigger = service.getTrigger();
        if (trigger != null) {
            jgen.writeObjectFieldStart("trigger");
            jgen.writeNumberField("rate", trigger.getRate());
            jgen.writeStringField("unit", trigger.getUnit().toString());
            jgen.writeEndObject();
        }
    }
}

