/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.jackson.datatype.services.dynamicproperty.deser.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.gravitee.definition.model.services.dynamicproperty.http.HttpDynamicPropertyProviderConfiguration;
import java.io.IOException;

public class HttpDynamicPropertyProviderConfigurationDeserializer
extends StdScalarDeserializer<HttpDynamicPropertyProviderConfiguration> {
    public HttpDynamicPropertyProviderConfigurationDeserializer(Class<HttpDynamicPropertyProviderConfiguration> vc) {
        super(vc);
    }

    public HttpDynamicPropertyProviderConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HttpDynamicPropertyProviderConfiguration configuration = new HttpDynamicPropertyProviderConfiguration();
        JsonNode urlNode = node.get("url");
        if (urlNode == null) {
            throw ctxt.mappingException("[dynamic-property] [HTTP] URL is required");
        }
        configuration.setUrl(urlNode.asText());
        JsonNode specificationNode = node.get("specification");
        if (specificationNode == null) {
            throw ctxt.mappingException("[dynamic-property] [HTTP] Specification is required");
        }
        configuration.setSpecification(specificationNode.asText());
        return configuration;
    }
}

