/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven.graal;

import io.helidon.build.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="native-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true)
public class GraalNativeMojo
extends AbstractMojo {
    private static final String EXEC_MODE_MAIN_CLASS = "main";
    private static final String EXEC_MODE_JAR = "jar";
    private static final String EXEC_MODE_JAR_WITH_CP = "jar-cp";
    private static final boolean IS_WINDOWS = File.pathSeparator != ":";
    private static final String NATIVE_IMAGE_CMD = "native-image";
    private static final List<String> WINDOWS_SCRIPT_EXTENSIONS = List.of("bat", "cmd", "ps1");
    private static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS = List.of("exe", "bin", "bat", "cmd", "ps1");
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.basedir}", required=true, property="native.image.currentDir")
    private File currentDir;
    @Parameter(defaultValue="${env.GRAALVM_HOME}")
    private File graalVMHome;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String finalName;
    @Parameter(defaultValue="true", property="native.image.reportExceptionStackTraces")
    private boolean reportExceptionStackTraces;
    @Parameter(defaultValue="true", property="native.image.noServer")
    private boolean noServer;
    @Parameter(defaultValue="true")
    private boolean addProjectResources;
    @Parameter(defaultValue="jar", property="native.image.execMode")
    private String execMode;
    @Parameter(defaultValue="${mainClass}", property="native.image.mainClass")
    private String mainClass;
    @Parameter
    private List<String> includeResources;
    @Parameter(defaultValue="false", property="native.image.buildShared")
    private boolean buildShared;
    @Parameter(defaultValue="false", property="native.image.buildStatic")
    private boolean buildStatic;
    @Parameter
    private List<String> additionalArgs;
    @Parameter(defaultValue="false", property="native.image.skip")
    private boolean skipNativeImage;
    private Process process;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Skip: " + this.skipNativeImage));
        this.getLog().debug((CharSequence)("Type: " + this.execMode));
        this.getLog().debug((CharSequence)("Main class: " + this.mainClass));
        if (this.skipNativeImage) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        NativeContext context = new NativeContext(this.execMode, this.mainClass);
        context.artifact(this.project, this.buildDirectory);
        context.validate();
        ArrayList<String> command = new ArrayList<String>();
        File nativeImageCmd = this.findNativeImageCmd();
        command.add(nativeImageCmd.getAbsolutePath());
        this.addStaticOrShared(command);
        String quoteToken = IS_WINDOWS && GraalNativeMojo.isWindowsScript(nativeImageCmd) ? "\"" : "";
        this.addNativeImageTarget(command, quoteToken);
        this.addResources(command, quoteToken);
        if (this.reportExceptionStackTraces) {
            command.add("-H:+ReportExceptionStackTraces");
        }
        if (this.noServer) {
            command.add("--no-server");
        }
        if (context.addClasspath()) {
            command.add("-classpath");
            command.add(this.getClasspath(context));
        }
        if (this.additionalArgs != null) {
            command.addAll(this.additionalArgs);
        }
        if (context.useJar()) {
            command.add("-jar");
            command.add(context.artifact().getAbsolutePath());
        }
        if (context.useMain()) {
            command.add(this.mainClass);
        }
        this.getLog().debug((CharSequence)("Executing command: " + command));
        ProcessBuilder pb = new ProcessBuilder(command.toArray(new String[0]));
        pb.directory(this.currentDir);
        Thread stdoutReader = new Thread(this::logStdout);
        Thread stderrReader = new Thread(this::logStderr);
        try {
            this.process = pb.start();
            stdoutReader.start();
            stderrReader.start();
            int exitCode = this.process.waitFor();
            stdoutReader.join();
            stderrReader.join();
            if (exitCode != 0) {
                throw new MojoFailureException("Image generation failed, exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Image generation error", ex);
        }
    }

    private void addResources(List<String> command, String quoteToken) {
        String resources = this.getResources();
        if (!resources.isEmpty()) {
            command.add("-H:IncludeResources=" + quoteToken + resources + quoteToken);
        }
    }

    private void addNativeImageTarget(List<String> command, String quoteToken) {
        Path outputPath = this.buildDirectory.toPath().resolve(this.finalName);
        this.getLog().info((CharSequence)("Building native image :" + outputPath.toAbsolutePath()));
        command.add("-H:Path=" + quoteToken + this.buildDirectory.getAbsolutePath() + quoteToken);
        command.add("-H:Name=" + quoteToken + this.finalName + quoteToken);
    }

    private void addStaticOrShared(List<String> command) throws MojoExecutionException {
        if (this.buildShared || this.buildStatic) {
            if (this.buildShared && this.buildStatic) {
                throw new MojoExecutionException("static and shared option cannot be used together");
            }
            if (this.buildShared) {
                this.getLog().info((CharSequence)"Building a shared library");
                command.add("--shared");
            }
            if (this.buildStatic) {
                this.getLog().info((CharSequence)"Building a statically linked executable");
                command.add("--static");
            }
        }
    }

    private void logStdout() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.getLog().info((CharSequence)line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void logStderr() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.getLog().warn((CharSequence)line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getResources() {
        this.getLog().debug((CharSequence)"Building resources string");
        ArrayList<String> resources = new ArrayList<String>();
        if (this.addProjectResources) {
            this.getLog().debug((CharSequence)"Scanning project resources");
            for (Resource resource : this.project.getResources()) {
                File resourcesDir = new File(resource.getDirectory());
                Scanner scanner = this.buildContext.newScanner(resourcesDir);
                String[] includes = null;
                if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                    includes = resource.getIncludes().toArray(new String[resource.getIncludes().size()]);
                }
                scanner.setIncludes(includes);
                String[] excludes = null;
                if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                    excludes = resource.getExcludes().toArray(new String[resource.getExcludes().size()]);
                }
                scanner.setExcludes(excludes);
                scanner.scan();
                for (String included : scanner.getIncludedFiles()) {
                    this.getLog().debug((CharSequence)("Found resource: " + included));
                    resources.add(included.replaceAll("\\\\", "/"));
                }
            }
        }
        if (this.includeResources != null) {
            this.getLog().debug((CharSequence)("Adding provided resources: " + this.includeResources));
            resources.addAll(this.includeResources);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        String resourcesStr = sb.toString();
        this.getLog().debug((CharSequence)("Built resources string: " + resourcesStr));
        return resourcesStr;
    }

    private String getClasspath(NativeContext context) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Building class-path string");
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            File targetClasses = new File(this.buildDirectory, "classes");
            LinkedList<String> classpathElements = new LinkedList<String>();
            if (context.useJar()) {
                for (String element : runtimeClasspathElements) {
                    File elementFile = new File(element);
                    if (targetClasses.equals(elementFile)) continue;
                    classpathElements.add(element);
                }
            } else {
                classpathElements.addAll(runtimeClasspathElements);
            }
            String classpath = String.join((CharSequence)File.pathSeparator, classpathElements);
            this.getLog().debug((CharSequence)("Built class-path: " + classpath));
            return classpath;
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Unable to get compile class-path", (Exception)((Object)ex));
        }
    }

    private static File findWindowsCmd(File dir, String cmd) {
        return WINDOWS_EXECUTABLE_EXTENSIONS.stream().map(ext -> new File(dir, cmd + "." + ext)).filter(File::isFile).map(File::getAbsoluteFile).findFirst().orElse(null);
    }

    private static boolean isWindowsScript(File cmd) {
        return WINDOWS_SCRIPT_EXTENSIONS.stream().filter(ext -> cmd.getAbsolutePath().endsWith("." + ext)).count() >= 1L;
    }

    private static File findCmd(File dir, String cmd) {
        File cmdFile = new File(dir, cmd);
        if (cmdFile.isFile()) {
            return cmdFile;
        }
        return IS_WINDOWS ? GraalNativeMojo.findWindowsCmd(dir, cmd) : null;
    }

    private File findNativeImageCmd() throws MojoExecutionException {
        if (this.graalVMHome == null || !this.graalVMHome.exists() || !this.graalVMHome.isDirectory()) {
            this.getLog().debug((CharSequence)"graalvm.home not set,looking in the PATH environment");
            String sysPath = System.getenv("PATH");
            if (Strings.isNotValid((String)sysPath)) {
                throw new MojoExecutionException("PATH environment variable is unset or empty");
            }
            for (String p : sysPath.split(File.pathSeparator)) {
                File cmd = GraalNativeMojo.findCmd(new File(p), NATIVE_IMAGE_CMD);
                if (cmd == null) continue;
                this.getLog().debug((CharSequence)("Found native-image: " + cmd));
                return cmd;
            }
            throw new MojoExecutionException("native-image not found in the PATH environment");
        }
        this.getLog().debug((CharSequence)"graalvm.home set, looking for bin/native-image");
        File binDir = new File(this.graalVMHome, "bin");
        if (!binDir.isDirectory()) {
            throw new MojoExecutionException("Unable to find native-image command, " + binDir.getAbsolutePath() + " is not a valid directory");
        }
        File cmd = GraalNativeMojo.findCmd(binDir, NATIVE_IMAGE_CMD);
        if (cmd != null) {
            this.getLog().debug((CharSequence)("Found native-image: " + cmd));
            return cmd;
        }
        throw new MojoExecutionException("native-image not found in directory: " + binDir.getAbsolutePath());
    }

    private static final class NativeContext {
        private final boolean useJar;
        private final boolean useMain;
        private final boolean addClasspath;
        private final String mainClass;
        private File artifact;

        private NativeContext(String execMode, String mainClass) throws MojoFailureException {
            this.mainClass = mainClass;
            switch (execMode) {
                case "jar": {
                    this.useJar = true;
                    this.useMain = false;
                    this.addClasspath = false;
                    break;
                }
                case "jar-cp": {
                    this.useJar = true;
                    this.useMain = false;
                    this.addClasspath = true;
                    break;
                }
                case "main": {
                    this.useJar = false;
                    this.useMain = true;
                    this.addClasspath = true;
                    break;
                }
                default: {
                    throw new MojoFailureException("Invalid configuration of \"execMode\". Has to be one of: jar, jar-cp, or main");
                }
            }
        }

        boolean useJar() {
            return this.useJar;
        }

        boolean useMain() {
            return this.useMain;
        }

        boolean addClasspath() {
            return this.addClasspath;
        }

        File artifact() {
            return this.artifact;
        }

        void artifact(MavenProject project, File buildDirectory) throws MojoFailureException {
            if (this.useJar) {
                this.artifact = project.getArtifact().getFile();
                if (this.artifact == null) {
                    this.artifact = new File(buildDirectory, project.getBuild().getFinalName() + ".jar");
                }
                if (!this.artifact.exists()) {
                    throw new MojoFailureException("Artifact does not exist: " + this.artifact.getAbsolutePath());
                }
            }
        }

        void validate() throws MojoFailureException {
            if (null == this.mainClass && this.useMain) {
                throw new MojoFailureException("Main class not configured and required. Use option \"mainClass\"");
            }
        }
    }
}

