/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.faulttolerance.AtomicCycle;
import java.util.concurrent.atomic.AtomicInteger;

final class ResultWindow {
    private final AtomicInteger currentSum = new AtomicInteger();
    private final AtomicCycle index;
    private final AtomicInteger[] results;
    private final AtomicInteger totalResults = new AtomicInteger();
    private final int thresholdSum;

    ResultWindow(int size, int ratio) {
        this.results = new AtomicInteger[size];
        for (int i = 0; i < size; ++i) {
            this.results[i] = new AtomicInteger();
        }
        this.index = new AtomicCycle(size - 1);
        int threshold = size * ratio / 100;
        this.thresholdSum = threshold == 0 ? 1 : threshold;
    }

    void update(Result resultEnum) {
        this.totalResults.incrementAndGet();
        int result = resultEnum.ordinal();
        AtomicInteger mine = this.results[this.index.incrementAndGet()];
        int origValue = mine.getAndSet(result);
        if (origValue == result) {
            return;
        }
        if (origValue == 1) {
            this.currentSum.decrementAndGet();
        } else {
            this.currentSum.incrementAndGet();
        }
    }

    boolean shouldOpen() {
        return this.totalResults.get() >= this.results.length && this.currentSum.get() >= this.thresholdSum;
    }

    void reset() {
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i].set(Result.SUCCESS.ordinal());
        }
        this.currentSum.set(0);
        this.index.set(this.results.length - 1);
        this.totalResults.set(0);
    }

    static enum Result {
        SUCCESS,
        FAILURE;

    }
}

