/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.http.Utils;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.PublisherInputStream;
import io.helidon.media.common.StringContentReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public final class ContentReaders {
    private static final Map<String, StringContentReader> CACHED_READERS = new ConcurrentHashMap<String, StringContentReader>();

    private static void addReader(Charset charset) {
        StringContentReader reader = new StringContentReader(charset);
        CACHED_READERS.put(charset.name(), reader);
    }

    private static void addReader(String charset) {
        try {
            ContentReaders.addReader(Charset.forName(charset));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ContentReaders() {
    }

    public static Reader<String> stringReader(Charset charset) {
        StringContentReader reader = CACHED_READERS.computeIfAbsent(charset.name(), key -> new StringContentReader(charset));
        return reader != null ? reader : new StringContentReader(charset);
    }

    static Reader<String> cachedStringReader(String charset) {
        return CACHED_READERS.get(charset);
    }

    public static Reader<byte[]> byteArrayReader() {
        return (publisher, clazz) -> {
            final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            final CompletableFuture future = new CompletableFuture();
            publisher.subscribe((Flow.Subscriber)new Flow.Subscriber<DataChunk>(){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onNext(DataChunk item) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = bytes;
                        synchronized (byteArrayOutputStream) {
                            Utils.write((ByteBuffer)item.data(), (OutputStream)bytes);
                        }
                    }
                    catch (IOException e) {
                        this.onError(new IllegalArgumentException("Cannot convert byte buffer to a byte array!", e));
                    }
                    finally {
                        item.release();
                    }
                }

                public void onError(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }

                public void onComplete() {
                    future.complete(bytes.toByteArray());
                }
            });
            return future;
        };
    }

    public static Reader<InputStream> inputStreamReader() {
        return (publisher, clazz) -> CompletableFuture.completedFuture(new PublisherInputStream((Flow.Publisher<DataChunk>)publisher));
    }

    static {
        ContentReaders.addReader(StandardCharsets.UTF_8);
        ContentReaders.addReader(StandardCharsets.UTF_16);
        ContentReaders.addReader(StandardCharsets.ISO_8859_1);
        ContentReaders.addReader(StandardCharsets.US_ASCII);
        ContentReaders.addReader("cp1252");
        ContentReaders.addReader("cp1250");
        ContentReaders.addReader("ISO-8859-2");
    }
}

