/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import java.io.Writer;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CharBuffer
extends Writer {
    private static final Pool POOL = new Pool(8192);
    private char[] buffer = POOL.acquire();
    private int count = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len - cbuf.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(cbuf, off, this.buffer, this.count, len);
        this.count += len;
    }

    int size() {
        return this.count;
    }

    ByteBuffer encode(Charset charset) {
        ByteBuffer result = charset.encode(java.nio.CharBuffer.wrap(this.buffer, 0, this.count));
        POOL.release(this.buffer);
        this.buffer = null;
        return result;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = CharBuffer.hugeCapacity(minCapacity);
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static class Pool {
        private volatile SoftReference<ConcurrentLinkedQueue<char[]>> reference;
        private final int arraySize;

        Pool(int arraySize) {
            this.arraySize = arraySize;
        }

        char[] acquire() {
            char[] array = this.getQueue().poll();
            return array == null ? new char[this.arraySize] : array;
        }

        void release(char[] array) {
            this.getQueue().offer(array);
        }

        private ConcurrentLinkedQueue<char[]> getQueue() {
            ConcurrentLinkedQueue<Object> queue;
            SoftReference<ConcurrentLinkedQueue<char[]>> reference = this.reference;
            if (reference != null && (queue = reference.get()) != null) {
                return queue;
            }
            queue = new ConcurrentLinkedQueue();
            this.reference = new SoftReference<ConcurrentLinkedQueue<char[]>>(queue);
            return queue;
        }
    }
}

