/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ReactiveStreamsAdapter;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.ReadableByteChannelPublisher;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class ContentWriters {
    private static final ByteArrayWriter COPY_BYTE_ARRAY_WRITER = new ByteArrayWriter(true);
    private static final ByteArrayWriter BYTE_ARRAY_WRITER = new ByteArrayWriter(false);
    private static final Map<Charset, CharSequenceWriter> CHAR_SEQUENCE_WRITERS = new HashMap<Charset, CharSequenceWriter>();
    private static final Map<Charset, CharBufferWriter> CHAR_BUFFER_WRITERS = new HashMap<Charset, CharBufferWriter>();

    private static void addWriters(Charset charset) {
        CHAR_SEQUENCE_WRITERS.put(charset, new CharSequenceWriter(charset));
        CHAR_BUFFER_WRITERS.put(charset, new CharBufferWriter(charset));
    }

    private static void addWriters(String charset) {
        try {
            ContentWriters.addWriters(Charset.forName(charset));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ContentWriters() {
    }

    public static Function<byte[], Flow.Publisher<DataChunk>> byteArrayWriter(boolean copy) {
        return copy ? COPY_BYTE_ARRAY_WRITER : BYTE_ARRAY_WRITER;
    }

    public static Function<CharSequence, Flow.Publisher<DataChunk>> charSequenceWriter(Charset charset) {
        return CHAR_SEQUENCE_WRITERS.computeIfAbsent(charset, key -> new CharSequenceWriter(charset));
    }

    public static Function<CharBuffer, Flow.Publisher<DataChunk>> charBufferWriter(Charset charset) {
        return CHAR_BUFFER_WRITERS.computeIfAbsent(charset, key -> new CharBufferWriter(charset));
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter(RetrySchema retrySchema) {
        RetrySchema schema = retrySchema == null ? RetrySchema.linear((long)0L, (long)10L, (long)250L) : retrySchema;
        return channel -> new ReadableByteChannelPublisher((ReadableByteChannel)channel, schema);
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter() {
        return ContentWriters.byteChannelWriter(null);
    }

    static {
        ContentWriters.addWriters(StandardCharsets.UTF_8);
        ContentWriters.addWriters(StandardCharsets.UTF_16);
        ContentWriters.addWriters(StandardCharsets.ISO_8859_1);
        ContentWriters.addWriters(StandardCharsets.US_ASCII);
        ContentWriters.addWriters("cp1252");
        ContentWriters.addWriters("cp1250");
        ContentWriters.addWriters("ISO-8859-2");
    }

    private static class CharBufferWriter
    implements Function<CharBuffer, Flow.Publisher<DataChunk>> {
        private final Charset charset;

        CharBufferWriter(Charset charset) {
            Objects.requireNonNull(charset, "Parameter 'charset' is null!");
            this.charset = charset;
        }

        @Override
        public Flow.Publisher<DataChunk> apply(CharBuffer buffer) {
            if (buffer == null || buffer.size() == 0) {
                return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
            }
            DataChunk chunk = DataChunk.create((boolean)false, (ByteBuffer)buffer.encode(this.charset), (boolean)true);
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.just((Object)chunk));
        }
    }

    private static class CharSequenceWriter
    implements Function<CharSequence, Flow.Publisher<DataChunk>> {
        private final Charset charset;

        CharSequenceWriter(Charset charset) {
            Objects.requireNonNull(charset, "Parameter 'charset' is null!");
            this.charset = charset;
        }

        CharSequenceWriter(String charset) {
            this(Charset.forName(charset));
        }

        @Override
        public Flow.Publisher<DataChunk> apply(CharSequence s) {
            if (s == null || s.length() == 0) {
                return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
            }
            DataChunk chunk = DataChunk.create((boolean)false, (ByteBuffer)this.charset.encode(s.toString()), (boolean)true);
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.just((Object)chunk));
        }
    }

    private static class ByteArrayWriter
    implements Function<byte[], Flow.Publisher<DataChunk>> {
        private final boolean copy;

        ByteArrayWriter(boolean copy) {
            this.copy = copy;
        }

        @Override
        public Flow.Publisher<DataChunk> apply(byte[] bytes) {
            byte[] bs;
            if (bytes == null || bytes.length == 0) {
                return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
            }
            if (this.copy) {
                bs = new byte[bytes.length];
                System.arraycopy(bytes, 0, bs, 0, bytes.length);
            } else {
                bs = bytes;
            }
            DataChunk chunk = DataChunk.create((boolean)false, (ByteBuffer)ByteBuffer.wrap(bs), (boolean)true);
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.just((Object)chunk));
        }
    }
}

