/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.RequestedCounter;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.SingleSubscriberHolder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadableByteChannelPublisher
implements Flow.Publisher<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(ReadableByteChannelPublisher.class.getName());
    private static final int DEFAULT_CHUNK_CAPACITY = 8192;
    private final ReadableByteChannel channel;
    private final RetrySchema retrySchema;
    private final SingleSubscriberHolder<DataChunk> subscriber = new SingleSubscriberHolder();
    private final RequestedCounter requested = new RequestedCounter();
    private final int chunkCapacity = 8192;
    private final AtomicBoolean publishing = new AtomicBoolean(false);
    private volatile AtomicInteger retryCounter = new AtomicInteger();
    private volatile long lastRetryDelay = 0L;
    private ScheduledExecutorService scheduledExecutorService;
    private volatile DataChunk curentChunk;

    public ReadableByteChannelPublisher(ReadableByteChannel channel, RetrySchema retrySchema) {
        this.channel = channel;
        this.retrySchema = retrySchema;
    }

    public void subscribe(Flow.Subscriber<? super DataChunk> subscriberParam) {
        if (this.subscriber.register(subscriberParam)) {
            this.publishing.set(true);
            try {
                subscriberParam.onSubscribe(new Flow.Subscription(){

                    public void request(long n) {
                        ReadableByteChannelPublisher.this.requested.increment(n, t -> ReadableByteChannelPublisher.this.tryComplete(t));
                        ReadableByteChannelPublisher.this.tryPublish();
                    }

                    public void cancel() {
                        ReadableByteChannelPublisher.this.subscriber.cancel();
                    }
                });
            }
            finally {
                this.publishing.set(false);
            }
            this.tryPublish();
        }
    }

    private DataChunk allocateNewChunk() {
        return DataChunk.create((boolean)false, (ByteBuffer)ByteBuffer.allocate(8192));
    }

    private boolean publishSingleOrFinish(Flow.Subscriber<? super DataChunk> subscr) throws Exception {
        DataChunk chunk;
        if (this.curentChunk == null) {
            chunk = this.allocateNewChunk();
        } else {
            chunk = this.curentChunk;
            this.curentChunk = null;
        }
        ByteBuffer bb = chunk.data();
        int count = 0;
        while (bb.remaining() > 0 && (count = this.channel.read(bb)) > 0) {
        }
        if (bb.capacity() > bb.remaining()) {
            bb.flip();
            subscr.onNext((Object)chunk);
        } else {
            this.curentChunk = chunk;
        }
        if (count < 0) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot close readable byte channel! (Close attempt after fully read channel.)", e);
            }
            this.tryComplete();
            if (this.curentChunk != null) {
                this.curentChunk.release();
            }
            return true;
        }
        return count > 0;
    }

    private void tryPublish() {
        boolean immediateRetry = true;
        while (immediateRetry) {
            long nextDelay;
            immediateRetry = false;
            if (this.subscriber.isClosed() || this.requested.get() <= 0L || !this.publishing.compareAndSet(false, true)) continue;
            try {
                Flow.Subscriber sub = this.subscriber.get();
                while (!this.subscriber.isClosed() && this.requested.tryDecrement()) {
                    if (this.publishSingleOrFinish((Flow.Subscriber<? super DataChunk>)sub)) continue;
                    this.requested.increment(1L, this::tryComplete);
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.tryComplete(e);
            }
            catch (Exception e) {
                this.tryComplete(e);
            }
            finally {
                this.publishing.set(false);
            }
            if (this.subscriber.isClosed() || this.requested.get() <= 0L) continue;
            this.lastRetryDelay = nextDelay = this.retrySchema.nextDelay(this.retryCounter.getAndIncrement(), this.lastRetryDelay);
            if (nextDelay < 0L) {
                this.tryComplete(new TimeoutException("Wait for the next item timeout!"));
                continue;
            }
            if (nextDelay == 0L) {
                immediateRetry = true;
                continue;
            }
            this.planNextTry(nextDelay);
        }
    }

    private synchronized void planNextTry(long afterMillis) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        this.scheduledExecutorService.schedule(this::tryPublish, afterMillis, TimeUnit.MILLISECONDS);
    }

    private void tryComplete() {
        this.subscriber.close(Flow.Subscriber::onComplete);
    }

    private void tryComplete(Throwable t) {
        this.subscriber.close(sub -> sub.onError(t));
    }
}

