/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.http.Utils;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.PublisherInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;

public final class ContentReaders {
    private ContentReaders() {
    }

    public static Single<byte[]> readBytes(Flow.Publisher<DataChunk> chunks) {
        return Multi.from(chunks).collect((Collector)new BytesCollector());
    }

    public static Single<String> readString(Flow.Publisher<DataChunk> chunks, Charset charset) {
        return ContentReaders.readBytes(chunks).map((Mapper)new BytesToString(charset));
    }

    public static Single<String> readURLEncodedString(Flow.Publisher<DataChunk> chunks, Charset charset) {
        return ContentReaders.readString(chunks, charset).map((Mapper)new StringToDecodedString(charset));
    }

    public static Reader<String> stringReader(Charset charset) {
        return (chunks, type) -> ContentReaders.readString((Flow.Publisher<DataChunk>)chunks, charset).toStage();
    }

    public static Reader<String> urlEncodedStringReader(Charset charset) {
        return (chunks, type) -> ContentReaders.readURLEncodedString((Flow.Publisher<DataChunk>)chunks, charset).toStage();
    }

    public static Reader<byte[]> byteArrayReader() {
        return (publisher, clazz) -> ContentReaders.readBytes((Flow.Publisher<DataChunk>)publisher).toStage();
    }

    public static Reader<InputStream> inputStreamReader() {
        return (publisher, clazz) -> CompletableFuture.completedFuture(new PublisherInputStream((Flow.Publisher<DataChunk>)publisher));
    }

    private static final class BytesCollector
    implements Collector<DataChunk, byte[]> {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        BytesCollector() {
        }

        public void collect(DataChunk chunk) {
            try {
                Utils.write((ByteBuffer)chunk.data(), (OutputStream)this.baos);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot convert byte buffer to a byte array!", e);
            }
            finally {
                chunk.release();
            }
        }

        public byte[] value() {
            return this.baos.toByteArray();
        }
    }

    private static final class StringToDecodedString
    implements Mapper<String, String> {
        private final Charset charset;

        StringToDecodedString(Charset charset) {
            this.charset = charset;
        }

        public String map(String s) {
            try {
                return URLDecoder.decode(s, this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class BytesToString
    implements Mapper<byte[], String> {
        private final Charset charset;

        BytesToString(Charset charset) {
            this.charset = charset;
        }

        public String map(byte[] bytes) {
            return new String(bytes, this.charset);
        }
    }
}

