/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Reader;
import io.helidon.common.reactive.Flow;
import io.helidon.media.common.ContentReaders;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

class StringContentReader
implements Reader<String> {
    private final Charset charset;
    private final UnsupportedCharsetException e;

    StringContentReader(Charset charset) {
        this.charset = charset;
        this.e = null;
    }

    StringContentReader(String charset) {
        Charset charsetLocal = null;
        UnsupportedCharsetException eLocal = null;
        try {
            charsetLocal = Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e) {
            eLocal = e;
        }
        this.charset = charsetLocal;
        this.e = eLocal;
    }

    public CompletionStage<String> apply(Flow.Publisher<DataChunk> publisher, Class<? super String> clazz) {
        if (this.charset != null) {
            return ContentReaders.byteArrayReader().apply(publisher, byte[].class).thenApply(bytes -> new String((byte[])bytes, this.charset));
        }
        CompletableFuture<String> result = new CompletableFuture<String>();
        result.completeExceptionally(new IllegalArgumentException("Cannot produce a string with the expected charset.", this.e));
        return result;
    }
}

