/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class ByteChannelBodyWriter
implements MessageBodyWriter<ReadableByteChannel> {
    private static final ByteChannelBodyWriter DEFAULT = new ByteChannelBodyWriter();
    private final ByteChannelToChunks mapper;

    private ByteChannelBodyWriter() {
        this.mapper = new ByteChannelToChunks();
    }

    private ByteChannelBodyWriter(RetrySchema schema) {
        this.mapper = new ByteChannelToChunks(schema);
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(ReadableByteChannel.class, type);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends ReadableByteChannel> content, GenericType<? extends ReadableByteChannel> type, MessageBodyWriterContext context) {
        context.contentType(MediaType.APPLICATION_OCTET_STREAM);
        return content.flatMap((Function)((Object)this.mapper));
    }

    static ByteChannelBodyWriter create(RetrySchema schema) {
        return new ByteChannelBodyWriter(schema);
    }

    static ByteChannelBodyWriter create() {
        return DEFAULT;
    }

    private static final class ByteChannelToChunks
    implements Mapper<ReadableByteChannel, Flow.Publisher<DataChunk>> {
        private final Function<ReadableByteChannel, Flow.Publisher<DataChunk>> publisherFunction;

        ByteChannelToChunks() {
            this.publisherFunction = channel -> IoMulti.multiFromByteChannel((ReadableByteChannel)channel).map(DataChunk::create);
        }

        ByteChannelToChunks(RetrySchema schema) {
            this.publisherFunction = channel -> IoMulti.multiFromByteChannelBuilder((ReadableByteChannel)channel).retrySchema(schema).build().map(DataChunk::create);
        }

        public Flow.Publisher<DataChunk> map(ReadableByteChannel channel) {
            return this.publisherFunction.apply(channel);
        }
    }
}

