/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.nio.charset.Charset;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class CharSequenceBodyWriter
implements MessageBodyWriter<CharSequence> {
    private static final CharSequenceBodyWriter DEFAULT = new CharSequenceBodyWriter();

    private CharSequenceBodyWriter() {
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(CharSequence.class, type);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends CharSequence> content, GenericType<? extends CharSequence> type, MessageBodyWriterContext context) {
        context.contentType(MediaType.TEXT_PLAIN);
        return content.flatMap((Function)((Object)new CharSequenceToChunks(context.charset())));
    }

    static CharSequenceBodyWriter create() {
        return DEFAULT;
    }

    private static final class CharSequenceToChunks
    implements Mapper<CharSequence, Flow.Publisher<DataChunk>> {
        private final Charset charset;

        CharSequenceToChunks(Charset charset) {
            this.charset = charset;
        }

        public Flow.Publisher<DataChunk> map(CharSequence content) {
            return ContentWriters.writeCharSequence(content, this.charset);
        }
    }
}

