/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentWriters;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Flow;
import java.util.function.Function;

final class FileBodyWriter
implements MessageBodyWriter<File> {
    private static final FileBodyWriter DEFAULT = new FileBodyWriter();

    private FileBodyWriter() {
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(File.class, type);
    }

    @Override
    public Flow.Publisher<DataChunk> write(Single<? extends File> content, GenericType<? extends File> type, MessageBodyWriterContext context) {
        return content.flatMap((Function)((Object)new FileToChunks(context)));
    }

    static FileBodyWriter create() {
        return DEFAULT;
    }

    private static final class FileToChunks
    implements Mapper<File, Flow.Publisher<DataChunk>> {
        private final MessageBodyWriterContext context;

        FileToChunks(MessageBodyWriterContext context) {
            this.context = context;
        }

        public Flow.Publisher<DataChunk> map(File file) {
            try {
                Path path = file.toPath();
                this.context.contentType(MediaType.APPLICATION_OCTET_STREAM);
                this.context.contentLength(Files.size(path));
                FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                return ContentWriters.byteChannelWriter().apply(fc);
            }
            catch (IOException ex) {
                return Single.error((Throwable)ex);
            }
        }
    }
}

