/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.FormParams;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FormParamsBodyReader
implements MessageBodyReader<FormParams> {
    private static final FormParamsBodyReader DEFAULT = new FormParamsBodyReader();
    private static final Map<MediaType, Pattern> PATTERNS = Map.of(MediaType.APPLICATION_FORM_URLENCODED, FormParamsBodyReader.preparePattern("&"), MediaType.TEXT_PLAIN, FormParamsBodyReader.preparePattern("\n"));

    private FormParamsBodyReader() {
    }

    static FormParamsBodyReader create() {
        return DEFAULT;
    }

    private static Pattern preparePattern(String assignmentSeparator) {
        return Pattern.compile(String.format("([^=%1$s]+)=?([^%1$s]+)?%1$s?", assignmentSeparator));
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        return context.contentType().filter(mediaType -> mediaType == MediaType.APPLICATION_FORM_URLENCODED || mediaType == MediaType.TEXT_PLAIN).map(it -> MessageBodyOperator.PredicateResult.supports(FormParams.class, type)).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    @Override
    public <U extends FormParams> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        MediaType mediaType = context.contentType().orElseThrow();
        Charset charset = mediaType.charset().map(Charset::forName).orElse(StandardCharsets.UTF_8);
        Function<String, String> decoder = this.decoder(mediaType, charset);
        return ContentReaders.readString(publisher, charset).map(formStr -> this.create((String)formStr, mediaType, decoder));
    }

    private FormParams create(String paramAssignments, MediaType mediaType, Function<String, String> decoder) {
        FormParams.Builder builder = FormParams.builder();
        Matcher m = PATTERNS.get(mediaType).matcher(paramAssignments);
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(2);
            if (value == null) {
                builder.add(decoder.apply(key), new String[0]);
                continue;
            }
            builder.add(decoder.apply(key), new String[]{decoder.apply(value)});
        }
        return builder.build();
    }

    private Function<String, String> decoder(MediaType mediaType, Charset charset) {
        if (mediaType == MediaType.TEXT_PLAIN) {
            return s -> s;
        }
        return s -> URLDecoder.decode(s, charset);
    }
}

