/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import java.util.concurrent.Flow;

final class StringBodyReader
implements MessageBodyReader<String> {
    private static final StringBodyReader DEFAULT = new StringBodyReader();

    private StringBodyReader() {
    }

    @Override
    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        return MessageBodyOperator.PredicateResult.supports(String.class, type);
    }

    @Override
    public <U extends String> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return ContentReaders.readString(publisher, context.charset());
    }

    static StringBodyReader create() {
        return DEFAULT;
    }
}

