/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Supplier;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;

final class HelidonGauge<T>
extends MetricImpl
implements Gauge<T> {
    private final Supplier<T> value = () -> metric.getValue();

    private HelidonGauge(String registryType, Metadata metadata, Gauge<T> metric) {
        super(registryType, metadata);
    }

    static HelidonGauge<?> create(String registryType, Metadata metadata, Gauge<?> metric) {
        return new HelidonGauge(registryType, metadata, metric);
    }

    public T getValue() {
        return this.value.get();
    }

    @Override
    protected void prometheusData(StringBuilder sb, String name, String tags) {
        MetricImpl.Units units = this.getUnits();
        String nameWithUnits = this.prometheusNameWithUnits(name, units.getPrometheusUnit());
        this.prometheusType(sb, nameWithUnits, this.getType());
        this.prometheusHelp(sb, nameWithUnits);
        sb.append(nameWithUnits).append(tags).append(" ").append(units.convert(this.getValue())).append('\n');
    }

    @Override
    public void jsonData(JsonObjectBuilder builder) {
        T value = this.getValue();
        String name = this.getName();
        if (value instanceof String) {
            builder.add(name, (String)value);
        } else if (value instanceof BigInteger) {
            builder.add(name, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            builder.add(name, (BigDecimal)value);
        } else if (value instanceof Integer) {
            builder.add(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(name, ((Long)value).longValue());
        } else if (value instanceof Double) {
            builder.add(name, ((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            builder.add(name, ((Boolean)value).booleanValue());
        } else {
            builder.add(name, String.valueOf(value));
        }
    }
}

