/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.HelidonGauge;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMeter;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.HelidonTimer;
import io.helidon.metrics.MetricImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

class Registry
extends MetricRegistry {
    private final MetricRegistry.Type type;
    private final Map<String, MetricImpl> allMetrics = new ConcurrentHashMap<String, MetricImpl>();

    protected Registry(MetricRegistry.Type type) {
        this.type = type;
    }

    public static Registry create(MetricRegistry.Type type) {
        return new Registry(type);
    }

    Optional<HelidonMetric> getMetric(String metricName) {
        return Optional.ofNullable((HelidonMetric)this.allMetrics.get(metricName));
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.register(this.toImpl(name, metric));
    }

    public <T extends Metric> T register(String name, T metric, Metadata metadata) throws IllegalArgumentException {
        return this.register(metadata, metric);
    }

    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(this.toImpl(metadata, metric));
    }

    private <T extends Metric> T register(MetricImpl impl) throws IllegalArgumentException {
        MetricImpl existing = this.allMetrics.putIfAbsent(impl.getName(), impl);
        if (null != existing) {
            throw new IllegalArgumentException("Attempting to register duplicate metric. New: " + impl + ", existing: " + existing);
        }
        return (T)impl;
    }

    public Counter counter(String name) {
        return this.counter(new Metadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return this.getMetric(metadata, Counter.class, name -> HelidonCounter.create(this.type.getName(), metadata));
    }

    public Histogram histogram(String name) {
        return this.histogram(new Metadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return this.getMetric(metadata, Histogram.class, name -> HelidonHistogram.create(this.type.getName(), metadata));
    }

    public Meter meter(String name) {
        return this.meter(new Metadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return this.getMetric(metadata, Meter.class, name -> HelidonMeter.create(this.type.getName(), metadata));
    }

    public Timer timer(String name) {
        return this.timer(new Metadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return this.getMetric(metadata, Timer.class, name -> HelidonTimer.create(this.type.getName(), metadata));
    }

    public boolean remove(String name) {
        return this.allMetrics.remove(name) != null;
    }

    public void removeMatching(MetricFilter filter) {
        this.allMetrics.entrySet().removeIf(entry -> filter.matches((String)entry.getKey(), (Metric)entry.getValue()));
    }

    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.allMetrics.keySet());
    }

    public SortedMap<String, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.getSortedMetrics(filter, Gauge.class);
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Counter.class);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.getSortedMetrics(filter, Histogram.class);
    }

    public SortedMap<String, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.getSortedMetrics(filter, Meter.class);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.getSortedMetrics(filter, Timer.class);
    }

    public Map<String, Metric> getMetrics() {
        return new HashMap<String, Metric>(this.allMetrics);
    }

    public Map<String, Metadata> getMetadata() {
        return new HashMap<String, Metadata>(this.allMetrics);
    }

    public Stream<? extends HelidonMetric> stream() {
        return this.allMetrics.values().stream();
    }

    public String type() {
        return this.type.getName();
    }

    public boolean empty() {
        return this.allMetrics.isEmpty();
    }

    MetricRegistry.Type registryType() {
        return this.type;
    }

    private <T extends Metric> MetricImpl toImpl(Metadata metadata, T metric) {
        switch (metadata.getTypeRaw()) {
            case COUNTER: {
                return HelidonCounter.create(this.type.getName(), metadata, (Counter)metric);
            }
            case GAUGE: {
                return HelidonGauge.create(this.type.getName(), metadata, (Gauge)metric);
            }
            case HISTOGRAM: {
                return HelidonHistogram.create(this.type.getName(), metadata, (Histogram)metric);
            }
            case METERED: {
                return HelidonMeter.create(this.type.getName(), metadata, (Meter)metric);
            }
            case TIMER: {
                return HelidonTimer.create(this.type.getName(), metadata, (Timer)metric);
            }
        }
        throw new IllegalArgumentException("Unexpected metric type " + metadata.getType() + ": " + metric.getClass().getName());
    }

    private <T extends Metric> MetricImpl toImpl(String name, T metric) {
        Class<?> clazz = metric.getClass();
        do {
            Optional<Class> optionalClass;
            if (!(optionalClass = Arrays.stream(clazz.getInterfaces()).filter(c -> Metric.class.isAssignableFrom((Class<?>)c)).findFirst()).isPresent()) continue;
            clazz = optionalClass.get();
            break;
        } while ((clazz = clazz.getSuperclass()) != null);
        return this.toImpl(new Metadata(name, MetricType.from(clazz == null ? metric.getClass() : clazz)), metric);
    }

    public String toString() {
        return this.type() + ": " + this.allMetrics.size() + " metrics";
    }

    private <V> SortedMap<String, V> getSortedMetrics(MetricFilter filter, Class<V> metricClass) {
        Map<String, Object> collected = this.allMetrics.entrySet().stream().filter(it -> metricClass.isAssignableFrom(((MetricImpl)it.getValue()).getClass())).filter(it -> filter.matches((String)it.getKey(), (Metric)it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, it -> metricClass.cast(it.getValue())));
        return new TreeMap<String, Object>(collected);
    }

    private <T extends Metric, I extends MetricImpl> T getMetric(Metadata metadata, Class<T> type, Function<String, I> newInstanceCreator) {
        MetricImpl metric = this.allMetrics.get(metadata.getName());
        if (metric != null) {
            if (metric.isReusable() != metadata.isReusable()) {
                throw new IllegalArgumentException("Metadata not re-usable for metric " + metadata.getName());
            }
        } else {
            metric = (MetricImpl)newInstanceCreator.apply(metadata.getName());
            metric.setReusable(metadata.isReusable());
            this.allMetrics.put(metadata.getName(), metric);
        }
        if (!type.isAssignableFrom(metric.getClass())) {
            throw new IllegalArgumentException("Attempting to get " + metadata.getType() + ", but metric registered under this name is " + metric);
        }
        return (T)((Metric)type.cast(metric));
    }
}

