/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.ItemStyle;
import edu.hm.hafner.echarts.Label;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class TreeMapNode {
    private final ItemStyle itemStyle;
    private final Label label;
    private final Label upperLabel;
    private String name;
    private final List<Double> values = new ArrayList<Double>();
    private final List<TreeMapNode> children = new ArrayList<TreeMapNode>();

    public TreeMapNode(String name) {
        this(name, 0.0);
    }

    public TreeMapNode(String name, double value) {
        this(name, "-", value, new double[0]);
    }

    public TreeMapNode(String name, String color, double value, double ... additionalValues) {
        this(name, new ItemStyle(color), new Label(false, "#ffffff"), new Label(false, "#ffffff"), value, additionalValues);
    }

    public TreeMapNode(String name, ItemStyle itemStyle, Label label, Label upperLabel, double value, double ... additionalValues) {
        this.itemStyle = itemStyle;
        this.label = label;
        this.upperLabel = upperLabel;
        this.name = name;
        this.values.add(value);
        Collections.addAll(this.values, ArrayUtils.toObject((double[])additionalValues));
    }

    public List<Double> getValue() {
        return Collections.unmodifiableList(this.values);
    }

    public String getName() {
        return this.name;
    }

    public ItemStyle getItemStyle() {
        return this.itemStyle;
    }

    public Label getLabel() {
        return this.label;
    }

    public Label getUpperLabel() {
        return this.upperLabel;
    }

    public List<TreeMapNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void insertNode(TreeMapNode node) {
        this.children.add(node);
    }

    public void collapseEmptyPackages() {
        while (this.children.size() == 1) {
            TreeMapNode singleChild = this.children.iterator().next();
            this.name = String.join((CharSequence)".", this.name, singleChild.getName());
            this.children.clear();
            this.children.addAll(singleChild.getChildren());
        }
    }

    public String toString() {
        return "'%s' (%s)".formatted(this.name, this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMapNode that = (TreeMapNode)o;
        if (!this.itemStyle.equals(that.itemStyle)) {
            return false;
        }
        if (!this.label.equals(that.label)) {
            return false;
        }
        if (!this.upperLabel.equals(that.upperLabel)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.values.equals(that.values)) {
            return false;
        }
        return this.children.equals(that.children);
    }

    public int hashCode() {
        int result = this.itemStyle.hashCode();
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.upperLabel.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.values.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }
}

